/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.procore.cluster.LongHash;

class LongIterator {
    private long[] longs;
    private int hashBase;
    private int index;
    private int size;
    private final LongHash.AllocatorI allocator;

    public LongIterator(LongHash.AllocatorI allocator) {
        this.allocator = allocator;
        this.reset();
    }

    public int size() {
        return this.size;
    }

    public void reset() {
        if (this.longs == null || LongHash.getUsedSize(this.longs, this.hashBase) != this.size || this.longs != this.allocator.getLongs() || this.hashBase != this.allocator.getHashBase()) {
            this.longs = this.allocator.getLongs();
            this.hashBase = this.allocator.getHashBase();
            this.size = LongHash.getUsedSize(this.longs, this.hashBase);
        }
        this.index = LongHash.getRealSize(this.longs, this.hashBase);
    }

    public long next() {
        if (this.moveToNextIndex()) {
            return this.longs[this.hashBase + this.index];
        }
        return LongHash.setFree();
    }

    protected final boolean moveToNextIndex() {
        this.index = this.nextIndex();
        return this.index >= 0;
    }

    protected final int nextIndex() {
        long[] states = this.longs;
        int i = this.index;
        while (i-- > 0 && !LongHash.isFull(states[this.hashBase + i])) {
        }
        return i;
    }

    public boolean hasNext() {
        return this.nextIndex() >= 0;
    }
}

