/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterChange;
import fi.vtt.simantics.procore.internal.ClusterStream;
import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.InputStream;
import org.simantics.db.Session;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterTranslator;
import org.simantics.db.impl.IClusterTable;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.service.ClusterUID;

public class ClusterTranslatorImpl
implements ClusterTranslator {
    private final SessionImplSocket session;
    private final ClusterStream clusterStream;
    private final ClusterTable clusterTable;

    ClusterTranslatorImpl(SessionImplSocket session) {
        this.session = session;
        this.clusterStream = session.clusterStream;
        this.clusterTable = session.clusterTable;
    }

    public byte[] getValueEx(int resourceIndex, long clusterId) throws DatabaseException {
        return this.session.graphSession.getResourceValue(resourceIndex, this.clusterTable.makeClusterUID(clusterId));
    }

    public InputStream getValueStreamEx(int resourceIndex, long clusterId) throws DatabaseException {
        return this.session.graphSession.getResourceValueStream(resourceIndex, this.clusterTable.makeClusterUID(clusterId), 0L, 0);
    }

    public byte[] getValueEx(int resourceIndex, long clusterId, long voffset, int length) throws DatabaseException {
        return this.session.graphSession.getResourceValue(resourceIndex, this.clusterTable.makeClusterUID(clusterId), voffset, length);
    }

    public long getValueSizeEx(int resourceIndex, long clusterId) throws DatabaseException {
        return this.session.graphSession.getResourceValueSize(resourceIndex, this.clusterTable.makeClusterUID(clusterId));
    }

    public int wait4RequestsLess(int limit) throws DatabaseException {
        return this.session.graphSession.wait4RequestsLess(limit);
    }

    public int createClusterKeyByClusterUID(ClusterUID clusterUID, long clusterId) {
        return this.clusterTable.makeProxy(clusterUID, clusterId).getClusterKey();
    }

    public int getClusterKeyByClusterUIDOrMake(ClusterUID clusterUID) {
        return this.clusterTable.getClusterKeyByClusterUIDOrMakeProxy(clusterUID);
    }

    public int getClusterKeyByClusterUIDOrMake(long id1, long id2) {
        return this.clusterTable.getClusterKeyByClusterUIDOrMakeProxy(id1, id2);
    }

    public ClusterBase getClusterByClusterUIDOrMake(ClusterUID clusterUID) {
        return this.clusterTable.getClusterByClusterUIDOrMakeProxy(clusterUID);
    }

    public final ClusterBase getClusterByClusterId(long clusterId) {
        ClusterImpl cluster = this.clusterTable.getClusterByClusterId(clusterId);
        if (cluster != null) {
            return cluster;
        }
        try {
            return this.clusterTable.getLoadOrThrow(clusterId);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            Logger.defaultLogError((String)("Cluster not found by id. cluster id=" + clusterId), (Throwable)e);
            return null;
        }
    }

    public ClusterBase getClusterByClusterKey(int clusterKey) {
        ClusterBase proxy = this.clusterTable.getClusterByClusterKey(clusterKey);
        if (proxy == null) {
            return null;
        }
        return proxy;
    }

    public ClusterBase getClusterByResourceKey(int resourceKey) {
        ClusterBase proxy = (ClusterBase)this.clusterTable.getClusterByResourceKey(resourceKey);
        if (proxy == null) {
            return null;
        }
        return proxy;
    }

    public long getClusterIdOrCreate(ClusterUID clusterUID) {
        return this.clusterTable.getClusterIdOrCreate(clusterUID);
    }

    public void createResource(Object cluster, short resourceIndex, long clusterId) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        if (this.clusterStream == null) {
            System.out.println("Temporary skip of clusterStream.createResource");
            return;
        }
        this.clusterStream.createResource(impl.cc, resourceIndex, this.clusterTable.makeClusterUID(clusterId));
    }

    public void addStatementIndex(Object cluster, int resourceKey, ClusterUID clusterUID, byte op) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.change == null) {
            return;
        }
        this.clusterStream.addStatementIndex(impl.change, resourceKey, clusterUID, op);
    }

    public void addStatement(Object cluster) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        this.clusterStream.addStatement(impl.cc, impl.change);
    }

    public void cancelStatement(Object cluster) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        this.clusterStream.cancelStatement(impl.change);
    }

    public void removeStatement(Object cluster) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        this.clusterStream.removeStatement(impl.cc, impl.change);
    }

    public void cancelValue(Object cluster) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        this.clusterStream.cancelValue(impl.change);
    }

    public void removeValue(Object cluster) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        this.clusterStream.removeValue(impl.cc, impl.change);
    }

    public void setValue(Object cluster, long clusterId, byte[] bytes, int length) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        this.clusterStream.setValue(impl.cc, impl.change, clusterId, bytes, length);
    }

    public void modiValue(Object cluster, long clusterId, long voffset, int length, byte[] bytes, int offset) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        this.clusterStream.modiValue(impl.cc, impl.change, clusterId, voffset, length, bytes, offset);
    }

    public void setStreamOff(boolean setOff) {
        this.clusterStream.setOff(setOff);
    }

    public boolean getStreamOff() {
        return this.clusterStream.getOff();
    }

    public void setImmutable(Object cluster, boolean immutable) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        this.clusterTable.markImmutable((ClusterI)impl, immutable);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        this.clusterStream.setImmutable(impl.cc, impl.change, immutable);
    }

    public void setDeleted(Object cluster, boolean deleted) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        this.clusterStream.setDeleted(impl.cc, impl.change, deleted);
    }

    public void undoValueEx(Object cluster, int resourceIndex) {
        ClusterImpl impl = (ClusterImpl)((Object)cluster);
        if (impl.cc == null) {
            impl.cc = new ClusterChange(this.clusterStream, impl);
        }
        this.clusterStream.undoValueEx(impl.cc, impl.change, resourceIndex);
    }

    public ResourceImpl getResource(int id) {
        return new ResourceImpl((ResourceSupport)this.session.resourceSupport, id);
    }

    public ResourceImpl getResource(int callerThread, int id) {
        assert (id != 0);
        return new ResourceImpl((ResourceSupport)this.session.resourceSupport, id);
    }

    public Session getSession() {
        return this.session;
    }

    public IClusterTable getClusterTable() {
        return this.clusterTable;
    }
}

