/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.Disposable;
import org.simantics.db.service.ClusterSets;
import org.simantics.db.service.ClusterSetsSupport;

public class ClusterSetsSupportImpl
implements ClusterSetsSupport,
Disposable {
    private static final boolean DEBUG = false;
    private static final Map<String, ClusterSets> sClusterSets = new HashMap<String, ClusterSets>();
    private final File filePath;
    private String databaseId;
    private ClusterSets clusterSets;

    ClusterSetsSupportImpl(File filePath) {
        this.filePath = filePath;
        this.databaseId = null;
        this.clusterSets = null;
    }

    public synchronized void connect(String databaseId) {
        assert (this.databaseId == null);
        this.databaseId = databaseId;
        this.clusterSets = sClusterSets.get(databaseId);
        int count = 1;
        if (this.clusterSets == null) {
            this.clusterSets = new ClusterSets(this.filePath, this.filePath, databaseId);
            sClusterSets.put(databaseId, this.clusterSets);
        } else {
            count = this.clusterSets.inc();
        }
    }

    public synchronized void dispose() {
        if (this.clusterSets == null) {
            return;
        }
        this.clusterSets.dispose();
        if (this.clusterSets.dec() <= 0) {
            sClusterSets.remove(this.databaseId);
        }
        this.clusterSets = null;
    }

    public synchronized boolean containsKey(long resourceId) {
        return this.clusterSets.containsKey(resourceId);
    }

    public synchronized Long get(Long resourceId) {
        return this.clusterSets.get(resourceId);
    }

    public synchronized void put(long resourceId, long clusterId) {
        this.clusterSets.put(resourceId, clusterId);
    }

    public synchronized void save() throws IOException {
        this.clusterSets.save();
    }

    public synchronized Long getSet(long clusterId) {
        return this.clusterSets.getClusterSet(Long.valueOf(clusterId));
    }

    public void clear() {
        this.clusterSets.clear();
    }

    public void updateWriteDirectory(Path write) {
    }

    public void setReadDirectory(Path read) {
    }
}

