package fi.vtt.simantics.procore.internal;

import org.simantics.db.service.TransactionSupport;

public class TransactionSupportImpl implements TransactionSupport {
	
	final private SessionImplSocket session;
	
	TransactionSupportImpl(SessionImplSocket session) {
		this.session = session;
	}
    
    private int getAsyncCount() {
        return session.state.getAsyncCount();
    }
	
    @Override
    public int getReadCount() {
        return session.state.getReadCount();
    }
    
    @Override
    public int getWriteCount() {
        return session.state.getWriteCount();
    }

    @Override
    public void waitCompletion() {
        while(getReadCount() > 0 || getWriteCount() > 0 || getAsyncCount() > 0) {
            try {
                Thread.sleep(10);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
    
}
