package fi.vtt.simantics.procore.internal;

import org.simantics.db.ExternalValueSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterTranslator;
import org.simantics.db.impl.ResourceImpl;

import fi.vtt.simantics.procore.DebugPolicy;

public class ExternalValueSupportImpl implements ExternalValueSupport {
    private final boolean DEBUG = DebugPolicy.REPORT_CLUSTER_EVENTS;
    private final SessionImplSocket session;
    private ClusterTranslator clusterTranslator;
    private final ClusterTable clusterTable;
    ExternalValueSupportImpl(SessionImplSocket session) {
        this.session = session;
        this.clusterTranslator = session.clusterTranslator;
        this.clusterTable = session.getClusterTable();
    }
    private final void check4Translator() {
        if (null == clusterTranslator)
            this.clusterTranslator = session.clusterTranslator;
    }
    @Override
    public void writeValue(WriteGraph graph, Resource resource, long offset, int length, byte[] bytes)
    throws DatabaseException {
        check4Translator();
        assert(length <= bytes.length);
        ResourceImpl resourceImpl = (ResourceImpl)resource;
        ClusterI cluster = clusterTable.getClusterByResourceKey(resourceImpl.id);
        cluster.modiValueEx(resourceImpl.id, offset, length, bytes, 0, clusterTranslator);
    }
// This breaks undo.
//    @Override
//    public void moveValue(WriteGraph graph, Resource resource)
//    throws DatabaseException {
//        this.writeValue(graph, resource, (1L<<58)-1, 0, new byte[0]);
//    }
// This breaks undo.
//    @Override
//    public void commitAndContinue(WriteGraph graph, WriteTraits wtraits, Resource resource)
//    throws DatabaseException {
//        XSupport xs = graph.getService(XSupport.class);
//        xs.commitAndContinue(graph, wtraits);
//        clusterTranslator.wait4RequestsLess(1);
//    }
    @Override
    public byte[] readValue(ReadGraph graph, Resource resource, long offset, int length)
    throws DatabaseException {
        check4Translator();
        ResourceImpl resourceImpl = (ResourceImpl)resource;
        ClusterI cluster = clusterTable.getClusterByResourceKey(resourceImpl.id);
        return cluster.readValueEx(resourceImpl.id, offset, length, clusterTranslator);
    }
    public long getValueSize(ReadGraph graph, Resource resource)
    throws DatabaseException {
        check4Translator();
        ResourceImpl resourceImpl = (ResourceImpl)resource;
        ClusterI cluster = clusterTable.getClusterByResourceKey(resourceImpl.id);
        long size = cluster.getValueSizeEx(resourceImpl.id, clusterTranslator);
        if (DEBUG)
            System.out.println("DEBUG:  resource=" + resource + " value length=" + size + ".");
        return size;
    }
    @Override
    public void removeValue(WriteGraph graph, Resource resource)
    throws DatabaseException {
        check4Translator();
        ResourceImpl resourceImpl = (ResourceImpl)resource;
        ClusterI cluster = clusterTable.getClusterByResourceKey(resourceImpl.id);
        cluster.modiValueEx(resourceImpl.id, 0, 0, new byte[0], 0, clusterTranslator);
        cluster.removeValue(resourceImpl.id, clusterTranslator);
    }
    @Override
    public int wait4RequestsLess(int limit)
    throws DatabaseException {
        check4Translator();
        return clusterTranslator.wait4RequestsLess(limit);
    }
}
