package fi.vtt.simantics.procore.internal;

import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.service.ClusterBuilder;
import org.simantics.db.service.ClusterUID;

import fi.vtt.simantics.procore.internal.SessionImplSocket.WriteOnlySupport;

public class ClusterBuilderImpl implements ClusterBuilder {
    
    final private ClusterTable clusterTable;
    final private ClusterStream stream;
    final private WriteOnlySupport support;
    
    ClusterBuilderImpl(SessionImplSocket session, WriteOnlySupport support) {
        this.support = support;
        this.stream = support.stream;
        this.clusterTable = session.clusterTable;
    }

    @Override
    public void newCluster() throws DatabaseException {
        support.flushCluster();
    }
    
    @Override
    public ResourceHandle newResource() throws DatabaseException {
        return new ResourceHandleImpl(support);
    }
    
    @Override
    public ResourceHandle resource(Resource res) throws DatabaseException {
        ResourceImpl r = (ResourceImpl)res;
        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKey(r.id);
        ClusterI cluster = clusterTable.getClusterByClusterKey(clusterKey);
        return new ResourceHandleImpl(stream, (ClusterImpl)cluster, r.id);
    }

    @Override
    public StatementHandle newStatement(ResourceHandle predicate, ResourceHandle object) throws DatabaseException {
        ResourceHandleImpl p = (ResourceHandleImpl)predicate;
        ResourceHandleImpl o = (ResourceHandleImpl)object;
        int pResourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey(p.resourceKey);
        ClusterI pCluster = clusterTable.getClusterByClusterKey(pResourceIndex);
        ClusterUID pClusterUID = pCluster.getClusterUID();
        int oResourceIndex = ClusterTraitsBase.getResourceIndexFromResourceKey(p.resourceKey);
        ClusterI oCluster = clusterTable.getClusterByClusterKey(oResourceIndex);
        ClusterUID oClusterUID = oCluster.getClusterUID();
        return new StatementHandleImpl(p.resourceKey, (byte)0, o.resourceKey, (byte)0, pClusterUID,  oClusterUID);
    }

}
