/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.simantics.db.ServerReference;
import org.simantics.db.common.utils.Logger;

/**
 * @author Toni Kalajainen
 */
public final class ProCoreServerReference implements ServerReference {
    public final Path dbFolder; // ProCoreServer is identified by database folder.
    public final InetSocketAddress socketAddress; // deprecated
    public final String dbid; // deprecated

    public ProCoreServerReference() {
    dbFolder = Paths.get("/"); // Assuming we don't have write rights to root.
    dbid = "";
    socketAddress = InetSocketAddress.createUnresolved("127.0.0.0", 0);
    }
    public ProCoreServerReference(Path dbFolder) {
        if (null == dbFolder) // Null means that caller does not care what the value is.
            dbFolder = Paths.get("/"); // Assuming we don't have write rights to root.
        this.dbFolder = dbFolder;
        dbid = "";
        socketAddress = InetSocketAddress.createUnresolved("127.0.0.0", 0);
    }
//    public ProCoreServerReference(ServerAddress address) throws InternalException {
//        Path dbFolder = Paths.get(address.getDbid()); // Maybe it would be better to let address resolve folder?
//        if (Files.isDirectory(dbFolder))
//            throw new ProCoreException("Server address does not contain valid database folder. address=" + address);
//        if (null == dbFolder) // Null means that caller does not care what the value is.
//            dbFolder = Paths.get("/"); // Assuming we don't have write rights to root.
//        this.dbFolder = dbFolder;
//        dbid = "";
//        socketAddress = InetSocketAddress.createUnresolved("127.0.0.0", 0);
//    }
    public ProCoreServerReference(Path dbFolder, String hostAndPort) {
        this.dbFolder = dbFolder;
        String[] split = hostAndPort.split(":");
        if (split.length != 2)
            throw new IllegalArgumentException("address does not contain a port, missing ':' character");
        this.socketAddress = InetSocketAddress.createUnresolved(split[0], Integer.parseInt(split[1]));
        this.dbid = null;
    }

    public ProCoreServerReference(Path dbFolder, String host, int port) {
        this.dbFolder = dbFolder;
        this.socketAddress = new InetSocketAddress(host, port);
        this.dbid = null;
    }

    public ProCoreServerReference(Path dbFolder, String host, int port, String dbid) {
        this.dbFolder = dbFolder;
        this.socketAddress = InetSocketAddress.createUnresolved(host, port);
        this.dbid = dbid;
    }

    public ProCoreServerReference(Path dbFolder, InetSocketAddress socketAddress) {
        this.dbFolder = dbFolder;
        this.socketAddress = socketAddress;
        this.dbid = null;
    }

    public ProCoreServerReference(Path dbFolder, InetSocketAddress socketAddress, String dbid) {
        this.dbFolder = dbFolder;
        this.socketAddress = socketAddress;
        this.dbid = dbid;
    }

    @Override
    public int hashCode() {
        return dbFolder.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        if (other == null || !(getClass().equals(other.getClass()))) return false;
        ProCoreServerReference r = (ProCoreServerReference) other;
        try {
            return Files.isSameFile(dbFolder, r.dbFolder);
        } catch (IOException e) {
            Logger.defaultLogError("Failed to compare db folders. f1=" + dbFolder + " f2=" + r.dbFolder, e);
            return false;
        }
    }

    @Override
    public String toString() {
        return dbFolder.toString();
    }
    @Override
    public Path getDBFolder() {
        return dbFolder;
    }

}
