/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.management;

import org.eclipse.core.runtime.ListenerList;

/**
 * @author Tuukka Lehtonen
 */
public class SessionContextProvider implements ISessionContextProvider {

    private ListenerList<ISessionContextChangedListener> listeners = new ListenerList<>();
    
    private Object          handle;

    private ISessionContext context;
    
    public SessionContextProvider(Object handle) {
        this.handle = handle;
    }
    
    public Object getHandle() {
        return handle;
    }

    public void setHandle(Object handle) {
        this.handle = handle;
    }

    @Override
    public void addContextChangedListener(ISessionContextChangedListener listener) {
        listeners.add(listener);
    }

    @Override
    public ISessionContext getSessionContext() {
        return context;
    }

    @Override
    public void removeContextChangedListener(ISessionContextChangedListener listener) {
        listeners.remove(listener);
    }

    private boolean safeEquals(Object o1, Object o2) {
        if (o1 == null)
            return o2 == null;
        return o1.equals(o2);
    }
    
    @Override
    public ISessionContext setSessionContext(ISessionContext context) {
        ISessionContext oldContext = this.context;
        this.context = context;

        if (!safeEquals(oldContext, context))
            fireChanged(oldContext, context);

        return oldContext;
    }

    protected void fireChanged(ISessionContext oldValue, ISessionContext newValue) {
        SessionContextChangedEvent event = new SessionContextChangedEvent(this, handle, oldValue, newValue);
        for (Object o : listeners.getListeners())
            ((ISessionContextChangedListener) o).sessionContextChanged(event);
    }

    @Override
    public String toString() {
        return "SessionContextProvider [handle=" + handle + ", context=" + context + "]";
    }

}
