/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.management;

/**
 * @see ISessionContextChangedListener
 * @see SessionContextChangedEvent
 * @see ISessionContext
 * 
 * @author Tuukka Lehtonen
 */
public interface ISessionContextProvider {

    /**
     * Adds a listener for selection changes in this selection provider.
     * Has no effect if an identical listener is already registered.
     *
     * @param listener a session context changed listener
     */
    public void addContextChangedListener(ISessionContextChangedListener listener);

    /**
     * Returns the current selection for this provider.
     * 
     * @return the current session context
     */
    public ISessionContext getSessionContext();

    /**
     * Removes the given selection change listener from this selection provider.
     * Has no affect if an identical listener is not registered.
     *
     * @param listener a session context changed listener
     */
    public void removeContextChangedListener(ISessionContextChangedListener listener);

    /**
     * Sets the current selection for this selection provider. The operation
     * must only fire {@link ISessionContextChangedListener}s if the
     * ISessionContext actually changed in the {@link #equals(Object)} sense.
     * 
     * @param context the new session context
     * @return the old ISessionContext or <code>null</code> there was no
     *         previous context
     */
    public ISessionContext setSessionContext(ISessionContext context);

}
