/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.text.Format;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.binding.reflection.GenericArrayBinding;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.RVIBuilder;
import org.simantics.db.layer0.variable.ValueProxyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.operation.Layer0X;

public class SubliteralPropertyVariableDeprecated
extends AbstractPropertyVariable {
    private final Variable parent;
    private final ChildReference reference;

    public SubliteralPropertyVariableDeprecated(Variable parent, ChildReference reference) {
        this.parent = parent;
        this.reference = reference;
    }

    @Override
    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        return this.parent.getPredicate(graph);
    }

    @Override
    public Resource getPropertyResource(ReadGraph graph) throws DatabaseException {
        if (this.parent instanceof AbstractPropertyVariable) {
            return ((AbstractPropertyVariable)this.parent).getPropertyResource(graph);
        }
        throw new RuntimeDatabaseException("not supported for parent " + this.parent);
    }

    @Override
    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        if (this.parent instanceof AbstractPropertyVariable) {
            return ((AbstractPropertyVariable)this.parent).getContainerResource(graph);
        }
        throw new RuntimeDatabaseException("not supported for parent " + this.parent);
    }

    protected String getReferenceString(ReadGraph graph) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        Format formatter = (Format)this.parent.getPossiblePropertyValue(graph, L0X.HasChildReferenceFormatter);
        if (formatter != null) {
            try {
                String format = formatter.format(this.reference);
                if (format != null) {
                    return format;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (this.reference instanceof IndexReference) {
            IndexReference index = (IndexReference)this.reference;
            return "[" + index.getIndex() + "]";
        }
        return this.reference.toString();
    }

    @Override
    public Variable getPossibleExtraProperty(ReadGraph graph, String name) throws DatabaseException {
        if ("HasDisplayProperty".equals(name)) {
            return new DisplayPropertyVariable(this.parent, this, this.getReferenceString(graph));
        }
        if ("HasDisplayUnit".equals(name)) {
            return new DisplayUnitVariable(this.parent, this);
        }
        return null;
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        Datatype parentType = this.parent.getDatatype(graph);
        if (parentType instanceof ArrayType) {
            ArrayType at = (ArrayType)parentType;
            return at.getComponentType(0);
        }
        return null;
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        Object parentValue = this.parent.getValue(graph);
        Datatype parentType = this.parent.getDatatype(graph);
        Binding parentBinding = Bindings.getBinding((Datatype)parentType);
        if (parentType instanceof ArrayType) {
            ArrayBinding ab = (ArrayBinding)parentBinding;
            IndexReference ref = (IndexReference)this.reference;
            try {
                return (T)ab.get(parentValue, ref.index);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
        throw new RuntimeDatabaseException("parent variable data type " + parentType + " is not an ArrayType");
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        Object parentValue = this.parent.getValue(graph);
        Datatype parentType = this.parent.getDatatype(graph);
        Binding parentBinding = Bindings.getBinding((Datatype)parentType);
        if (parentType instanceof ArrayType) {
            ArrayBinding ab = (ArrayBinding)parentBinding;
            IndexReference ref = (IndexReference)this.reference;
            try {
                Object indexValue = ab.get(parentValue, ref.index);
                return (T)Bindings.adapt((Object)indexValue, (Binding)ab.getComponentBinding(), (Binding)binding);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (AdaptException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
        throw new RuntimeDatabaseException("parent variable data type " + parentType + " is not an ArrayType");
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        Object parentValue = this.parent.getValue((ReadGraph)graph);
        Datatype parentType = this.parent.getDatatype((ReadGraph)graph);
        if (parentType instanceof ArrayType) {
            Binding parentBinding = Bindings.getBinding((Datatype)parentType);
            ArrayBinding ab = (ArrayBinding)parentBinding;
            IndexReference ref = (IndexReference)this.reference;
            try {
                Object indexValue = this.adaptValueForArray(parentValue, value, binding, ab.getComponentBinding());
                if (indexValue == value) {
                    ab = this.resolveArrayBinding(parentValue.getClass(), binding);
                }
                ab.set(parentValue, ref.index, indexValue);
                this.parent.setValue(graph, parentValue, (Binding)ab);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (AdaptException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
    }

    private ArrayBinding resolveArrayBinding(Class<? extends Object> arrayClass, Binding binding) {
        Class<?> componentClass = arrayClass.getComponentType();
        if (componentClass.isPrimitive()) {
            if (componentClass == Boolean.TYPE) {
                return Bindings.BOOLEAN_ARRAY;
            }
            if (componentClass == Byte.TYPE) {
                return Bindings.BYTE_ARRAY;
            }
            if (componentClass == Integer.TYPE) {
                return Bindings.INT_ARRAY;
            }
            if (componentClass == Long.TYPE) {
                return Bindings.LONG_ARRAY;
            }
            if (componentClass == Float.TYPE) {
                return Bindings.FLOAT_ARRAY;
            }
            if (componentClass == Double.TYPE) {
                return Bindings.DOUBLE_ARRAY;
            }
        }
        if (componentClass.equals(String.class)) {
            return Bindings.STRING_ARRAY;
        }
        return new GenericArrayBinding(arrayClass, new ArrayType(binding.type()), binding);
    }

    private Object adaptValueForArray(Object array, Object indexValue, Binding from, Binding to) throws AdaptException {
        Class<?> arrayType = array.getClass();
        if (!arrayType.isArray()) {
            throw new AdaptException("array " + array + " is not of an array class");
        }
        Class<?> arrayComponentType = arrayType.getComponentType();
        if (arrayComponentType.isAssignableFrom(indexValue.getClass())) {
            return indexValue;
        }
        return Bindings.adapt((Object)indexValue, (Binding)from, (Binding)to);
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return this.reference.toString(false);
    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    @Override
    public Variables.Role getRole(ReadGraph graph) throws DatabaseException {
        return Variables.Role.CHILD;
    }

    @Override
    public RVI.RVIPart getRVIPart(ReadGraph graph) throws DatabaseException {
        return new RVI.StringRVIPart(Variables.Role.CHILD, this.reference.toString(false));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SubliteralPropertyVariableDeprecated)) {
            return false;
        }
        SubliteralPropertyVariableDeprecated other = (SubliteralPropertyVariableDeprecated)obj;
        return this.reference.equals(other.reference);
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.reference.hashCode();
    }

    static class DisplayPropertyVariable
    extends ValueProxyVariable {
        private String suffix;

        public DisplayPropertyVariable(Variable proxy, Variable parent, String suffix) {
            super(proxy, parent);
            assert (suffix != null);
            this.suffix = suffix;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DisplayPropertyVariable)) {
                return false;
            }
            DisplayPropertyVariable other = (DisplayPropertyVariable)obj;
            return this.proxy.equals(other.proxy) && this.suffix.equals(this.suffix);
        }

        @Override
        public int hashCode() {
            return this.proxy.hashCode() * 31 + this.suffix.hashCode();
        }

        @Override
        public String getURI(ReadGraph graph) throws DatabaseException {
            return String.valueOf(this.parent.getURI(graph)) + Variables.Role.PROPERTY.getIdentifier() + this.getName(graph);
        }

        @Override
        public String getName(ReadGraph graph) throws DatabaseException {
            return "HasDisplayProperty";
        }

        @Override
        public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
            return Datatypes.STRING;
        }

        @Override
        public RVI getRVI(ReadGraph graph) throws DatabaseException {
            return new RVIBuilder(this.parent.getRVI(graph)).append(new RVI.StringRVIPart(Variables.Role.PROPERTY, this.getName(graph))).toRVI();
        }

        @Override
        public <T> T getPossibleValue(ReadGraph graph) throws DatabaseException {
            return this.getPossibleValue(graph, (Binding)Bindings.STRING);
        }

        @Override
        public <T> T getPossibleValue(ReadGraph graph, Binding binding) throws DatabaseException {
            String str = (String)this.proxy.getPossiblePropertyValue(graph, "HasDisplayProperty", (Binding)Bindings.STRING);
            return (T)(str != null ? String.valueOf(str) + " " + this.suffix : null);
        }

        @Override
        public <T> T getValue(ReadGraph graph) throws DatabaseException {
            return this.getValue(graph, (Binding)Bindings.STRING);
        }

        @Override
        public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
            return (T)(this.proxy.getPropertyValue(graph, "HasDisplayProperty", binding) + " " + this.suffix);
        }

        @Override
        public Variant getVariantValue(ReadGraph graph) throws DatabaseException {
            return new Variant((Binding)Bindings.STRING, this.getValue(graph, (Binding)Bindings.STRING));
        }
    }

    static class DisplayUnitVariable
    extends ValueProxyVariable {
        public DisplayUnitVariable(Variable proxy, Variable parent) {
            super(proxy, parent);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DisplayUnitVariable)) {
                return false;
            }
            DisplayUnitVariable other = (DisplayUnitVariable)obj;
            return this.proxy.equals(other.proxy);
        }

        @Override
        public int hashCode() {
            return this.proxy.hashCode() * 53;
        }

        @Override
        public String getURI(ReadGraph graph) throws DatabaseException {
            return String.valueOf(this.parent.getURI(graph)) + Variables.Role.PROPERTY.getIdentifier() + this.getName(graph);
        }

        @Override
        public String getName(ReadGraph graph) throws DatabaseException {
            return "HasDisplayUnit";
        }

        @Override
        public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
            return Datatypes.STRING;
        }

        @Override
        public RVI getRVI(ReadGraph graph) throws DatabaseException {
            return new RVIBuilder(this.parent.getRVI(graph)).append(new RVI.StringRVIPart(Variables.Role.PROPERTY, this.getName(graph))).toRVI();
        }

        @Override
        public <T> T getPossibleValue(ReadGraph graph) throws DatabaseException {
            return this.getPossibleValue(graph, (Binding)Bindings.STRING);
        }

        @Override
        public <T> T getPossibleValue(ReadGraph graph, Binding binding) throws DatabaseException {
            return this.proxy.getPossiblePropertyValue(graph, "HasDisplayUnit", (Binding)Bindings.STRING);
        }

        @Override
        public <T> T getValue(ReadGraph graph) throws DatabaseException {
            return this.getValue(graph, (Binding)Bindings.STRING);
        }

        @Override
        public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
            return this.proxy.getPropertyValue(graph, "HasDisplayUnit", binding);
        }

        @Override
        public Variant getVariantValue(ReadGraph graph) throws DatabaseException {
            return new Variant((Binding)Bindings.STRING, this.getValue(graph, (Binding)Bindings.STRING));
        }
    }
}

