/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.annotations.Union;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVIBuilder;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.layer0.Layer0;

public class RVI
extends Bean {
    private static final RVIPart[] NONE = new RVIPart[0];
    public RVIPart[] parts;

    public RVI() {
    }

    public RVI(Binding rviBinding) {
        super(rviBinding);
    }

    public static RVI empty(Binding rviBinding) {
        RVI result = new RVI(rviBinding);
        result.parts = NONE;
        return result;
    }

    public boolean isEmpty() {
        return this.parts.length == 0;
    }

    public Variable resolve(ReadGraph graph, Variable base) throws DatabaseException {
        RVIPart[] rVIPartArray = this.parts;
        int n = this.parts.length;
        int n2 = 0;
        while (n2 < n) {
            RVIPart part = rVIPartArray[n2];
            base = base.resolve(graph, part);
            ++n2;
        }
        return base;
    }

    public Variable resolvePossible(ReadGraph graph, Variable base) throws DatabaseException {
        RVIPart[] rVIPartArray = this.parts;
        int n = this.parts.length;
        int n2 = 0;
        while (n2 < n) {
            RVIPart part = rVIPartArray[n2];
            if ((base = base.resolvePossible(graph, part)) == null) {
                return null;
            }
            ++n2;
        }
        return base;
    }

    public int hashCode() {
        return Arrays.hashCode(this.parts);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RVI other = (RVI)((Object)obj);
        return Arrays.equals(this.parts, other.parts);
    }

    public String asString(ReadGraph graph, Variable base) throws DatabaseException {
        String baseURI = base.getURI(graph);
        Variable resolved = this.resolve(graph, base);
        return resolved.getURI(graph).substring(baseURI.length());
    }

    public UniqueRead<String> asStringRequest(final Resource base) {
        return new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Variable v = Variables.getConfigurationContext(graph, base);
                return RVI.this.asString(graph, v);
            }
        };
    }

    public String asPossibleString(ReadGraph graph, Variable base) throws DatabaseException {
        try {
            return this.asString(graph, base);
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        RVIPart[] rVIPartArray = this.parts;
        int n = this.parts.length;
        int n2 = 0;
        while (n2 < n) {
            RVIPart p = rVIPartArray[n2];
            if (p instanceof ResourceRVIPart) {
                sb.append(p.toString());
            } else if (p instanceof StringRVIPart) {
                sb.append(((StringRVIPart)p).toEscapedString());
            } else if (p instanceof GuidRVIPart) {
                sb.append(((GuidRVIPart)p).toEscapedString());
            }
            ++n2;
        }
        return sb.toString();
    }

    public String toPossibleString(ReadGraph graph, Variable base) throws DatabaseException {
        String baseURI = base.getURI(graph);
        Variable resolved = null;
        int i = 0;
        while (i < this.parts.length) {
            RVIPart p = this.parts[i];
            if ((base = base.resolvePossible(graph, p)) == null) break;
            resolved = base;
            ++i;
        }
        if (resolved == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String resolvedURI = resolved.getURI(graph);
        sb.append(resolvedURI, baseURI.length(), resolvedURI.length());
        if (i < this.parts.length) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            while (i < this.parts.length) {
                RVIPart p = this.parts[i];
                if (p instanceof ResourceRVIPart) {
                    Resource r = ((ResourceRVIPart)p).resource;
                    String str = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
                    if (str == null) {
                        return null;
                    }
                    sb.append(p.getRole().getIdentifier()).append(URIStringUtils.escape((String)str));
                } else if (p instanceof StringRVIPart) {
                    sb.append(p.getRole().getIdentifier()).append(URIStringUtils.escape((String)((StringRVIPart)p).string));
                } else if (p instanceof GuidRVIPart) {
                    sb.append(p.getRole().getIdentifier()).append(((GuidRVIPart)p).mostSignificant).append(":").append(((GuidRVIPart)p).leastSignificant);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public String toString(ReadGraph graph) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        RVIPart[] rVIPartArray = this.parts;
        int n = this.parts.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            RVIPart p = rVIPartArray[n2];
            if (p instanceof ResourceRVIPart) {
                Resource r = ((ResourceRVIPart)p).resource;
                String str2 = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                sb.append(p.getRole().getIdentifier()).append(str2);
            } else if (p instanceof StringRVIPart) {
                str = p.toString();
                sb.append(str);
            } else if (p instanceof GuidRVIPart) {
                str = p.toString();
                sb.append(str);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static RVI fromResourceFormat(RequestProcessor proc, String str) {
        SerialisationSupport support = (SerialisationSupport)proc.getService(SerialisationSupport.class);
        if (support == null) {
            throw new RuntimeException("No serialization support in Session");
        }
        Databoard databoard = (Databoard)proc.getService(Databoard.class);
        if (databoard == null) {
            throw new RuntimeException("No databoard support in Session");
        }
        Binding rviBinding = databoard.getBindingUnchecked(RVI.class);
        RVIBuilder rb = new RVIBuilder(rviBinding);
        int pos = 0;
        int len = str.length();
        while (pos < str.length()) {
            String[] parts;
            String x;
            int end;
            Variables.Role role = null;
            char c = str.charAt(pos);
            if (c == '#') {
                ++pos;
                role = Variables.Role.PROPERTY;
            } else if (c == '/') {
                ++pos;
                role = Variables.Role.CHILD;
            } else {
                role = Variables.Role.CHILD;
            }
            int e1 = str.indexOf(35, pos);
            int e2 = str.indexOf(47, pos);
            e1 = e1 < 0 ? len : e1;
            e2 = e2 < 0 ? len : e2;
            int n = end = e1 < e2 ? e1 : e2;
            if (str.charAt(pos) == 'r' && !(x = str.substring(pos + 1, end)).isEmpty()) {
                try {
                    long res = (int)Long.parseLong(x);
                    Resource r = support.getResource(res);
                    rb.append(role, r);
                    pos = end;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (DatabaseException databaseException) {}
            }
            if (str.indexOf(":", pos) > -1 && !(x = str.substring(pos, end)).isEmpty() && (parts = x.split(":")).length == 3) {
                try {
                    long res = (int)Long.parseLong(parts[2]);
                    long mostSignificant = Long.parseLong(parts[0]);
                    long leastSignificant = Long.parseLong(parts[1]);
                    Resource r = support.getResource(res);
                    rb.append(role, r, mostSignificant, leastSignificant);
                    pos = end;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (DatabaseException databaseException) {}
            }
            String text = URIStringUtils.unescape((String)str.substring(pos, end));
            pos = end;
            rb.append(role, text);
        }
        return rb.toRVI();
    }

    public static class GuidRVIPart
    implements RVIPart {
        public Variables.Role role;
        public long mostSignificant;
        public long leastSignificant;
        public transient Resource resource;

        @Override
        public Variables.Role getRole() {
            return this.role;
        }

        public GuidRVIPart() {
        }

        public GuidRVIPart(Variables.Role role, Resource resource, long mostSignificant, long leastSignificant) {
            this.role = role;
            this.resource = resource;
            this.mostSignificant = mostSignificant;
            this.leastSignificant = leastSignificant;
        }

        public String toString() {
            return String.valueOf(this.role.getIdentifier()) + this.mostSignificant + ":" + this.leastSignificant;
        }

        public String toEscapedString() {
            String rid = this.resource != null ? Long.toString(this.resource.getResourceId()) : "0";
            return String.valueOf(this.role.getIdentifier()) + this.mostSignificant + ":" + this.leastSignificant + ":" + rid;
        }

        public int hashCode() {
            return (GuidRVIPart.longHashCode(this.leastSignificant) * 51 + GuidRVIPart.longHashCode(this.mostSignificant)) * 31 + this.role.hashCode();
        }

        private static int longHashCode(long value) {
            return (int)(value ^ value >>> 32);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GuidRVIPart other = (GuidRVIPart)obj;
            return this.role == other.role && this.leastSignificant == other.leastSignificant && this.mostSignificant == other.mostSignificant;
        }
    }

    @Union(value={ResourceRVIPart.class, StringRVIPart.class, GuidRVIPart.class})
    public static interface RVIPart {
        public Variables.Role getRole();
    }

    public static class ResourceRVIPart
    implements RVIPart {
        public Variables.Role role;
        public Resource resource;

        @Override
        public Variables.Role getRole() {
            return this.role;
        }

        public ResourceRVIPart() {
        }

        public ResourceRVIPart(Variables.Role role, Resource resource) {
            if (resource == null) {
                throw new NullPointerException("null resource");
            }
            this.role = role;
            this.resource = resource;
        }

        public String toString() {
            return String.valueOf(this.role.getIdentifier()) + "r" + Long.toString(this.resource.getResourceId());
        }

        public int hashCode() {
            return this.resource.hashCode() * 31 + this.role.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceRVIPart other = (ResourceRVIPart)obj;
            return this.role == other.role && this.resource.equals(other.resource);
        }
    }

    public static class StringRVIPart
    implements RVIPart {
        public Variables.Role role;
        public String string;

        @Override
        public Variables.Role getRole() {
            return this.role;
        }

        public StringRVIPart() {
        }

        public StringRVIPart(Variables.Role role, String string) {
            if (string == null) {
                throw new NullPointerException("null string");
            }
            this.role = role;
            this.string = string;
        }

        public String toString() {
            return String.valueOf(this.role.getIdentifier()) + this.string;
        }

        public String toEscapedString() {
            return String.valueOf(this.role.getIdentifier()) + URIStringUtils.escape((String)this.string);
        }

        public int hashCode() {
            return this.string.hashCode() * 31 + this.role.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringRVIPart other = (StringRVIPart)obj;
            return this.role == other.role && this.string.equals(other.string);
        }
    }
}

