/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.layer0.Layer0;

public abstract class NodeManagerVariableBuilder
implements VariableBuilder {
    public Variable buildChild(ReadGraph graph, Variable parent, VariableNode node, Resource child) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String childName = (String)graph.getRelatedValue(child, L0.HasName, (Binding)Bindings.STRING);
        String sessionName = String.valueOf(parent.getURI(graph)) + "/" + childName;
        return this.createChild(graph, parent, sessionName, child);
    }

    protected Variable createChild(ReadGraph graph, Variable parent, String sessionName, Resource child) throws DatabaseException {
        NodeSupport<?> support = this.getNodeSupport(graph, sessionName);
        return new StandardGraphChildVariable(parent, new VariableNode(support, this.getRoot(graph, support, sessionName)), child);
    }

    public Variable buildProperty(ReadGraph graph, Variable parent, VariableNode node, Resource subject, Resource predicate) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    protected abstract NodeSupport<?> getNodeSupport(ReadGraph var1, String var2) throws DatabaseException;

    protected abstract Object getRoot(ReadGraph var1, NodeSupport<?> var2, String var3) throws DatabaseException;
}

