/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public abstract class HierarchyMultiMap<A, B> {
    THashMap<A, List<B>> map = new THashMap();
    THashMap<A, List<B>> cache;

    public synchronized void put(A a, B b) {
        ArrayList<B> bs = (ArrayList<B>)this.map.get(a);
        if (bs == null) {
            bs = new ArrayList<B>(2);
            this.map.put(a, bs);
        }
        bs.add(b);
        this.cache = null;
    }

    public synchronized List<B> get(ReadGraph g, A a) throws DatabaseException {
        List<Object> bs;
        if (this.cache == null) {
            this.cache = new THashMap();
        }
        if ((bs = (ArrayList)this.cache.get(a)) == null) {
            ArrayList base = (ArrayList)this.map.get(a);
            Collection<A> supers = this.getImmediateSuperelements(g, a);
            if (base == null) {
                if (supers.isEmpty()) {
                    bs = Collections.emptyList();
                } else if (supers.size() == 1) {
                    bs = this.get(g, supers.iterator().next());
                } else {
                    THashSet temp = new THashSet();
                    for (A s : supers) {
                        temp.addAll(this.get(g, s));
                    }
                    bs = new ArrayList(temp);
                    this.sort(bs);
                }
            } else if (supers.isEmpty()) {
                bs = base;
                this.sort(bs);
            } else {
                bs = new ArrayList(base);
                THashSet filter = new THashSet(base);
                for (A s : supers) {
                    for (B b : this.get(g, s)) {
                        if (!filter.add(b)) continue;
                        bs.add(b);
                    }
                }
                if (bs.size() == base.size()) {
                    bs = base;
                }
                this.sort(bs);
            }
            this.cache.put(a, bs);
        }
        return bs;
    }

    protected abstract Collection<A> getImmediateSuperelements(ReadGraph var1, A var2) throws DatabaseException;

    protected void sort(List<B> values) {
    }
}

