/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ResourceMap;
import org.simantics.db.Statement;
import org.simantics.db.common.StandardStatement;
import org.simantics.db.common.primitiverequest.Value;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.ConsistsOfProcess;
import org.simantics.db.layer0.util.DomainProcessorState;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.TransferableGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainProcessor3 {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainProcessor3.class);
    private static final boolean PROFILE = false;
    Serializer variantSerializer;
    Serializer datatypeSerializer;
    Binding datatypeBinding;
    boolean ignoreVirtual;
    int id = 0;
    Set<Resource> fringe = null;
    Function1<Statement, ExclusionDecision> exclusionFunction = null;
    Set<Resource> predicates = null;
    Map<Resource, Boolean> isRelatedToPredicates = null;
    Set<Resource> deadPredicates = null;
    Set<Resource> strongInverseSet = null;
    List<Statement> unresolvedWeakLinks = new ArrayList<Statement>();
    TIntIntHashMap ids = null;
    ResourceMap<SubgraphExtent.ExtentStatus> status = null;
    Map<Datatype, byte[]> bindings = new HashMap<Datatype, byte[]>();
    final SerialisationSupport support;
    final TransferableGraphConfiguration2 conf;
    final TransferableGraphSupport tgs;
    private Layer0 L0;
    private long composedObjectCounter = 0L;
    private long fastInternalCounter = 0L;
    private long parentExternalCounter = 0L;
    private long fullInternalCounter = 0L;
    private long fullExternalCounter = 0L;
    long startupTime = 0L;
    long expandTime = 0L;
    long fullResolveTime = 0L;
    long fastResolveTime = 0L;
    long otherStatementTime = 0L;
    long parentResolveTime = 0L;
    long extentSeedTime = 0L;
    long classifyPredicateTime = 0L;
    long processFringeTime = 0L;
    long valueOutputTime = 0L;
    long statementOutputTime = 0L;
    private TIntArrayList stream = new TIntArrayList();
    private long internalResourceNumber = 0L;
    private long startTime = 0L;
    private long lastUpdateTime = 0L;

    public DomainProcessor3(ReadGraph graph, TransferableGraphConfiguration2 conf, DomainProcessorState state, boolean ignoreVirtual) throws DatabaseException {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.tgs = (TransferableGraphSupport)graph.getService(TransferableGraphSupport.class);
        this.support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        this.ignoreVirtual = ignoreVirtual;
        this.conf = conf;
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        this.ids = state.ids;
        this.status = (ResourceMap)cs.createMap(SubgraphExtent.ExtentStatus.class);
        this.predicates = cs.createSet();
        this.exclusionFunction = conf.exclusionFunction;
        this.fringe = new TreeSet<Resource>();
        this.isRelatedToPredicates = (Map)cs.createMap(Boolean.class);
        this.deadPredicates = cs.createSet();
        this.strongInverseSet = cs.createSet();
        if (LOGGER.isDebugEnabled()) {
            for (Map.Entry<Resource, SubgraphExtent.ExtentStatus> entry : conf.preStatus.entrySet()) {
                LOGGER.debug("prestatus: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)entry.getKey()) + " " + (Object)((Object)entry.getValue()));
            }
            for (TransferableGraphConfiguration2.SeedSpec ss : conf.seeds) {
                LOGGER.debug("seed: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)ss.resource) + " " + ss.name + " " + (Object)((Object)ss.specType) + " " + ss.type);
            }
        }
        for (Map.Entry<Resource, SubgraphExtent.ExtentStatus> entry : conf.preStatus.entrySet()) {
            if (entry.getValue().equals((Object)SubgraphExtent.ExtentStatus.INTERNAL)) {
                LOGGER.info("Unexpected INTERNAL preStatus in DomainProcessor3 " + entry.getKey());
                continue;
            }
            this.status.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        for (TransferableGraphConfiguration2.SeedSpec ss : conf.seeds) {
            SubgraphExtent.ExtentStatus pre = (SubgraphExtent.ExtentStatus)((Object)this.status.get((Object)ss.resource));
            if (TransferableGraphConfiguration2.SeedSpec.SeedSpecType.INTERNAL.equals((Object)ss.specType)) {
                if (pre == null || SubgraphExtent.ExtentStatus.INTERNAL.equals((Object)pre)) continue;
                LOGGER.info("Internal seed preclassification problem, expected INTERNAL preclassification, got " + pre.name());
                continue;
            }
            if (TransferableGraphConfiguration2.SeedSpec.SeedSpecType.ROOT.equals((Object)ss.specType)) {
                this.fringe.add(ss.resource);
                if (pre != null) {
                    LOGGER.info("Root preclassification problem, expected no preclassification, got " + pre.name());
                }
                this.status.put((Object)ss.resource, (Object)SubgraphExtent.ExtentStatus.INTERNAL);
                continue;
            }
            if (!TransferableGraphConfiguration2.SeedSpec.SeedSpecType.SPECIAL_ROOT.equals((Object)ss.specType)) continue;
            if (pre != null && !SubgraphExtent.ExtentStatus.EXTERNAL.equals((Object)pre)) {
                LOGGER.info("Special root preclassification problem, expected EXTERNAL preclassification, got " + pre.name());
            }
            this.status.put((Object)ss.resource, (Object)SubgraphExtent.ExtentStatus.EXTERNAL);
        }
    }

    public ResourceMap<SubgraphExtent.ExtentStatus> getStatus() {
        return this.status;
    }

    public Collection<DirectStatements> extractFromFringe(ReadGraph graph, int maxAmount) throws DatabaseException {
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        List list = cs.createList();
        Iterator<Resource> it = this.fringe.iterator();
        int i = 0;
        while (i < maxAmount) {
            if (!it.hasNext()) break;
            list.add(it.next());
            it.remove();
            ++i;
        }
        return (Collection)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest.Expansion3(list, this.ignoreVirtual));
    }

    public Collection<DirectStatements> expand(ReadGraph graph) throws DatabaseException {
        Collection<DirectStatements> result = this.extractFromFringe(graph, 8192);
        return result;
    }

    public void classifyPredicates(ReadGraph graph, Set<Resource> schedule, DomainProcessorState state) throws DatabaseException {
        for (Resource predicate : schedule) {
            Boolean isRelatedTo = Boolean.FALSE;
            Resource single = graph.getPossibleSuperrelation(predicate);
            if (single != null) {
                Boolean singleIsRelatedTo = this.isRelatedToPredicates.get(single);
                if (singleIsRelatedTo == null) {
                    singleIsRelatedTo = graph.isSubrelationOf(single, this.L0.IsRelatedTo);
                    this.isRelatedToPredicates.put(single, singleIsRelatedTo);
                }
                isRelatedTo = singleIsRelatedTo;
            } else if (graph.isSubrelationOf(predicate, this.L0.IsRelatedTo)) {
                isRelatedTo = Boolean.TRUE;
            } else if (!graph.hasStatement(predicate)) {
                this.deadPredicates.add(predicate);
                state.inverses.remove(this.support.getTransientId(predicate));
            }
            this.isRelatedToPredicates.put(predicate, isRelatedTo);
        }
    }

    public void classifyPredicates(ReadGraph graph, DomainProcessorState state, Collection<DirectStatements> expansion) throws DatabaseException {
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Set schedule = cs.createSet();
        Map newPredicates = (Map)cs.createMap(Resource.class);
        for (DirectStatements directStatements : expansion) {
            for (Statement stm : directStatements) {
                ExclusionDecision decision;
                Resource predicate = stm.getPredicate();
                Resource object = stm.getObject();
                if (SubgraphExtent.ExtentStatus.EXCLUDED.equals(this.status.get((Object)predicate)) || SubgraphExtent.ExtentStatus.EXCLUDED.equals(this.status.get((Object)object))) continue;
                if (this.exclusionFunction != null && ExclusionDecision.EXCLUDE_OBJECT.equals((Object)(decision = (ExclusionDecision)((Object)this.exclusionFunction.apply((Object)stm))))) {
                    this.status.put((Object)object, (Object)SubgraphExtent.ExtentStatus.EXCLUDED);
                    continue;
                }
                if (!this.predicates.add(predicate)) continue;
                Resource inverse = graph.getPossibleInverse(predicate);
                schedule.add(predicate);
                if (inverse != null) {
                    newPredicates.put(predicate, inverse);
                    if (this.predicates.add(inverse)) {
                        schedule.add(inverse);
                    }
                    state.inverses.put(this.support.getTransientId(predicate), this.support.getTransientId(inverse));
                    state.inverses.put(this.support.getTransientId(inverse), this.support.getTransientId(predicate));
                    continue;
                }
                state.inverses.put(this.support.getTransientId(predicate), 0);
            }
        }
        this.classifyPredicates(graph, schedule, state);
        for (Map.Entry entry : newPredicates.entrySet()) {
            Boolean isRelatedToKey;
            Boolean isRelatedToValue = this.isRelatedToPredicates.get(entry.getValue());
            if (isRelatedToValue.booleanValue()) {
                this.strongInverseSet.add((Resource)entry.getKey());
            }
            if (!(isRelatedToKey = this.isRelatedToPredicates.get(entry.getKey())).booleanValue()) continue;
            this.strongInverseSet.add((Resource)entry.getValue());
        }
    }

    private Datatype getDatatype(ReadGraph graph, Resource subject) throws DatabaseException {
        Resource object = graph.getSingleObject(subject, this.L0.HasDataType);
        return (Datatype)graph.syncRequest((Read)new Value(object, this.datatypeBinding), (Listener)TransientCacheListener.instance());
    }

    public void processValue(ReadGraph graph, Resource subject, int sId, final DomainProcessorState state) throws DatabaseException, IOException {
        final InputStream valueStream = this.tgs.getValueStream(graph, subject);
        if (valueStream != null) {
            state.valueOutput.writeInt(sId);
            if (this.conf.values) {
                byte[] typeBytes;
                Datatype dt = this.getDatatype(graph, subject);
                boolean canWriteRawVariant = !state.valueModifier.mayNeedModification(dt);
                long rawVariantSizePos = 0L;
                state.valueOutput.writeByte(canWriteRawVariant ? 1 : 2);
                if (canWriteRawVariant) {
                    rawVariantSizePos = state.valueOutput.position();
                    state.valueOutput.writeInt(0);
                }
                if ((typeBytes = this.bindings.get(dt)) == null) {
                    typeBytes = this.datatypeSerializer.serialize((Object)dt);
                    this.bindings.put(dt, typeBytes);
                }
                state.valueOutput.write(typeBytes);
                Serializer s = Bindings.getSerializerUnchecked((Binding)Bindings.getBinding((Datatype)dt));
                s.skip(new InputStream(){

                    @Override
                    public int read() throws IOException {
                        int value = valueStream.read();
                        state.valueOutput.write(value);
                        return value;
                    }
                });
                if (canWriteRawVariant) {
                    long currentPos = state.valueOutput.position();
                    int variantSize = (int)(currentPos - rawVariantSizePos - 4L);
                    state.valueOutput.position(rawVariantSizePos);
                    state.valueOutput.writeInt(variantSize);
                    state.valueOutput.position(currentPos);
                }
            }
            ++state.valueCount;
        }
    }

    public void addToStream(Resource predicate, Resource object) throws DatabaseException {
        this.stream.add(this.support.getTransientId(predicate));
        this.stream.add(this.support.getTransientId(object));
    }

    public void processStatement(ReadGraph graph, Resource subject, Statement stm) throws DatabaseException, IOException {
        Resource predicate = stm.getPredicate();
        Resource object = stm.getObject();
        SubgraphExtent.ExtentStatus objectStatus = (SubgraphExtent.ExtentStatus)((Object)this.status.get((Object)object));
        Boolean isRelatedTo = this.isRelatedToPredicates.get(predicate);
        if (objectStatus != SubgraphExtent.ExtentStatus.EXCLUDED && isRelatedTo.booleanValue()) {
            this.addToStream(predicate, object);
            if (objectStatus == null || objectStatus == SubgraphExtent.ExtentStatus.PENDING) {
                this.fringe.add(object);
            }
        } else {
            if (this.deadPredicates.contains(predicate)) {
                return;
            }
            if (objectStatus != SubgraphExtent.ExtentStatus.EXCLUDED && !this.strongInverseSet.contains(predicate)) {
                this.unresolvedWeakLinks.add((Statement)new StandardStatement(subject, predicate, object));
                if (objectStatus == null) {
                    this.status.put((Object)object, (Object)SubgraphExtent.ExtentStatus.PENDING);
                }
            }
        }
    }

    public void flushStatementStream(int sId, DomainProcessorState state) throws IOException {
        if (!this.stream.isEmpty()) {
            state.statementsOutput.writeInt(sId);
            int streamSize = this.stream.size();
            int statementCount = this.stream.size() / 2;
            state.statementsOutput.writeInt(statementCount);
            int i = 0;
            while (i < streamSize) {
                state.statementsOutput.writeInt(this.stream.getQuick(i));
                ++i;
            }
            state.statementCount += 2 * streamSize;
            this.stream.resetQuick();
        }
    }

    public void processInternal(ReadGraph graph, Resource subject, DirectStatements stms, DomainProcessorState state) throws DatabaseException, IOException {
        ++this.internalResourceNumber;
        long t = System.nanoTime();
        long dt = t - this.lastUpdateTime;
        if (dt > 200000000L) {
            if (this.startTime == 0L) {
                this.startTime = t;
            }
            this.lastUpdateTime = t;
            double totalTime = (double)(t - this.startTime) * 1.0E-9;
            if (totalTime > 0.0) {
                long speed = Math.round((double)this.internalResourceNumber / totalTime);
                state.monitor.subTask("Included " + this.internalResourceNumber + " resources (" + speed + " resources/s)");
            }
        }
        this.status.put((Object)subject, (Object)SubgraphExtent.ExtentStatus.INTERNAL);
        int sId = this.support.getTransientId(subject);
        this.processValue(graph, subject, sId, state);
        for (Statement stm : stms) {
            this.processStatement(graph, subject, stm);
        }
        this.flushStatementStream(sId, state);
        state.monitor.setWorkRemaining(100000);
        state.monitor.worked(1);
    }

    public void processFringe(ReadGraph graph, Collection<DirectStatements> expansion, DomainProcessorState state) throws DatabaseException, IOException {
        for (DirectStatements stms : expansion) {
            Resource subject = stms.getSubject();
            boolean partOf = false;
            for (Statement stm : stms) {
                Resource predicate = stm.getPredicate();
                if (!this.L0.PartOf.equals(predicate)) continue;
                partOf = true;
                break;
            }
            SubgraphExtent.ExtentStatus subjectStatus = (SubgraphExtent.ExtentStatus)((Object)this.status.get((Object)subject));
            if (subjectStatus == SubgraphExtent.ExtentStatus.EXTERNAL || subjectStatus == SubgraphExtent.ExtentStatus.EXCLUDED) continue;
            if (partOf && (subjectStatus == null || SubgraphExtent.ExtentStatus.PENDING == subjectStatus) && graph.getPossibleURI(subject) != null) {
                this.status.put((Object)subject, (Object)SubgraphExtent.ExtentStatus.EXTERNAL);
                continue;
            }
            this.processInternal(graph, subject, stms, state);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void process(ReadGraph graph, DomainProcessorState state) throws DatabaseException {
        try {
            this.variantSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked((Binding)Bindings.VARIANT);
            this.datatypeBinding = Bindings.getBindingUnchecked(Datatype.class);
            this.datatypeSerializer = ((Databoard)graph.getService(Databoard.class)).getSerializerUnchecked(this.datatypeBinding);
            pair = ConsistsOfProcess.walk(graph, this.status, this.conf.seeds, this.ignoreVirtual);
            state.internalEntries = (List)pair.first;
            for (ConsistsOfProcess.ConsistsOfProcessEntry entry : state.internalEntries) {
                r = entry.resource;
                if (this.status.put((Object)r, (Object)SubgraphExtent.ExtentStatus.INTERNAL) != null) continue;
                this.fringe.add(r);
            }
            for (Resource unnamedChild : (Set)pair.second) {
                if (this.status.put((Object)unnamedChild, (Object)SubgraphExtent.ExtentStatus.INTERNAL) != null) continue;
                this.fringe.add(unnamedChild);
            }
            if (!state.monitor.isCanceled()) ** GOTO lbl25
            throw new CancelTransactionException();
lbl-1000:
            // 1 sources

            {
                expansion = this.expand(graph);
                this.classifyPredicates(graph, state, expansion);
                this.processFringe(graph, expansion, state);
                if (!state.monitor.isCanceled()) continue;
                throw new CancelTransactionException();
lbl25:
                // 2 sources

                ** while (!this.fringe.isEmpty())
            }
lbl26:
            // 1 sources

        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    void logStatementWithExtent(ReadGraph graph, String header, SubgraphExtent.ExtentStatus status, int sId, int pId, int oId) throws DatabaseException {
    }

    void logStatementWithExtent(ReadGraph graph, String header, SubgraphExtent.ExtentStatus status, Resource sId, Resource pId, Resource oId) throws DatabaseException {
    }

    public static enum ExclusionDecision {
        INCLUDE,
        EXCLUDE_OBJECT;

    }
}

