/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.request.Read;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseExceptionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseExceptionUtils.class);

    public static String showResource(Resource resource) {
        return DatabaseExceptionUtils.showResource((RequestProcessor)SimanticsInternal.getSession(), resource);
    }

    public static String showResource(RequestProcessor processor, final Resource resource) {
        try {
            return (String)processor.syncRequest((Read)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)resource);
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Unknown error while evaluating debug name for a resource " + resource, (Throwable)e);
            return resource.toString();
        }
    }
}

