/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public class PropertyInfo {
    public final Resource predicate;
    public final String name;
    public final boolean isImmutable;
    public final boolean isHasProperty;
    public final boolean isFunctional;
    public final Set<String> classifications;
    public final VariableBuilder builder;
    public final Resource literalRange;
    public final Datatype requiredDatatype;
    public final String requiredValueType;
    public final String definedUnit;
    public final Binding defaultBinding;
    public final Map<String, Pair<Resource, ChildReference>> subliteralPredicates;
    public final ValueAccessor valueAccessor;
    public final boolean hasEnumerationRange;

    public PropertyInfo(Resource predicate, String name, boolean isImmutable, boolean isFunctional, boolean isHasProperty, Set<String> classifications, VariableBuilder builder, Resource literalRange, Datatype requiredDatatype, String definedUnit, String requiredValueType, Binding defaultBinding, Map<String, Pair<Resource, ChildReference>> subliteralPredicates, ValueAccessor valueAccessor, boolean hasEnumerationRange) {
        this.predicate = predicate;
        this.name = name;
        this.isImmutable = isImmutable;
        this.isFunctional = isFunctional;
        this.isHasProperty = isHasProperty;
        this.classifications = classifications;
        this.builder = builder;
        this.literalRange = literalRange;
        this.requiredDatatype = requiredDatatype;
        this.definedUnit = definedUnit;
        this.requiredValueType = requiredValueType;
        this.defaultBinding = defaultBinding;
        this.subliteralPredicates = subliteralPredicates;
        this.valueAccessor = valueAccessor;
        this.hasEnumerationRange = hasEnumerationRange;
    }

    public static PropertyInfo make(ReadGraph graph, Resource predicate, String name, boolean isFunctional, boolean isHasProperty, Set<String> classifications, VariableBuilder builder, Resource literalRange, Datatype requiredDatatype, String definedUnit, String requiredValueType, Map<String, Pair<Resource, ChildReference>> subliteralPredicates, ValueAccessor valueAccessor, boolean hasEnumerationRange) throws DatabaseException {
        Collection dts;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (literalRange != null && (dts = graph.getAssertedObjects(literalRange, L0.HasDataType)).size() == 1) {
            Datatype dt = (Datatype)graph.getPossibleValue((Resource)dts.iterator().next(), Bindings.DATATYPE);
            if (requiredDatatype == null) {
                requiredDatatype = dt;
            }
        }
        Binding defaultBinding = requiredDatatype != null ? Bindings.getBinding((Datatype)requiredDatatype) : null;
        return new PropertyInfo(predicate, name, graph.isImmutable(predicate), isFunctional, isHasProperty, classifications, builder, literalRange, requiredDatatype, definedUnit, requiredValueType, defaultBinding, subliteralPredicates, valueAccessor, hasEnumerationRange);
    }

    public boolean hasClassification(String classification) {
        return this.classifications.contains(classification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PropertyInfo [").append(this.name).append(" : ").append(this.requiredDatatype).append(" :: ").append(this.requiredValueType).append(", predicate=").append(this.predicate).append(", isFunctional=").append(this.isFunctional).append(", isHasProperty=").append(this.isHasProperty).append(", hasEnumerationRange=").append(this.hasEnumerationRange).append(", definedUnit=").append(this.definedUnit != null ? this.definedUnit : "<none>").append(", defaultBinding=").append(this.defaultBinding).append(", valueAccessor=").append(this.valueAccessor).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
        if (!this.isImmutable) {
            result = 31 * result + (this.builder == null ? 0 : this.builder.hashCode());
            result = 31 * result + (this.classifications == null ? 0 : this.classifications.hashCode());
            result = 31 * result + (this.defaultBinding == null ? 0 : this.defaultBinding.hashCode());
            result = 31 * result + (this.definedUnit == null ? 0 : this.definedUnit.hashCode());
            result = 31 * result + (this.hasEnumerationRange ? 1231 : 1237);
            result = 31 * result + (this.isFunctional ? 1231 : 1237);
            result = 31 * result + (this.isHasProperty ? 1231 : 1237);
            result = 31 * result + (this.literalRange == null ? 0 : this.literalRange.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.requiredDatatype == null ? 0 : this.requiredDatatype.hashCode());
            result = 31 * result + (this.requiredValueType == null ? 0 : this.requiredValueType.hashCode());
            result = 31 * result + (this.subliteralPredicates == null ? 0 : this.subliteralPredicates.hashCode());
            result = 31 * result + (this.valueAccessor == null ? 0 : this.valueAccessor.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyInfo other = (PropertyInfo)obj;
        if (this.predicate == null ? other.predicate != null : !this.predicate.equals(other.predicate)) {
            return false;
        }
        if (this.isImmutable) {
            return true;
        }
        if (this.builder == null ? other.builder != null : !this.builder.equals(other.builder)) {
            return false;
        }
        if (this.classifications == null ? other.classifications != null : !this.classifications.equals(other.classifications)) {
            return false;
        }
        if (this.defaultBinding == null ? other.defaultBinding != null : !this.defaultBinding.equals((Object)other.defaultBinding)) {
            return false;
        }
        if (this.definedUnit == null ? other.definedUnit != null : !this.definedUnit.equals(other.definedUnit)) {
            return false;
        }
        if (this.hasEnumerationRange != other.hasEnumerationRange) {
            return false;
        }
        if (this.isFunctional != other.isFunctional) {
            return false;
        }
        if (this.isHasProperty != other.isHasProperty) {
            return false;
        }
        if (this.literalRange == null ? other.literalRange != null : !this.literalRange.equals(other.literalRange)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.requiredDatatype == null ? other.requiredDatatype != null : !this.requiredDatatype.equals((Object)other.requiredDatatype)) {
            return false;
        }
        if (this.requiredValueType == null ? other.requiredValueType != null : !this.requiredValueType.equals(other.requiredValueType)) {
            return false;
        }
        if (this.subliteralPredicates == null ? other.subliteralPredicates != null : !this.subliteralPredicates.equals(other.subliteralPredicates)) {
            return false;
        }
        return !(this.valueAccessor == null ? other.valueAccessor != null : !this.valueAccessor.equals(other.valueAccessor));
    }
}

