/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;

public class ClassificationsRequest
extends UnaryRead<Collection<Resource>, Set<String>> {
    public ClassificationsRequest(Collection<Resource> principalTypes) {
        super(principalTypes);
    }

    public Set<String> perform(ReadGraph graph) throws DatabaseException {
        HashSet<String> result = new HashSet<String>(((Collection)this.parameter).size());
        HashSet allTypes = new HashSet((Collection)this.parameter);
        for (Resource principalType : (Collection)this.parameter) {
            allTypes.addAll(graph.getSupertypes(principalType));
        }
        for (Resource type : allTypes) {
            String uri = graph.getPossibleURI(type);
            if (uri == null) continue;
            result.add(uri);
        }
        return result;
    }
}

