/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public final class EntityNameModifier
implements StringModifier {
    private Resource entity;
    private Resource property;
    private boolean hasUri;
    private Map<String, Resource> namesInUse = Collections.emptyMap();
    private Layer0 L0;
    private final String initial;
    private final String version;

    public EntityNameModifier(ReadGraph graph, Resource entity, Resource property) throws DatabaseException {
        this.entity = entity;
        this.property = property;
        this.initialize(graph);
        this.initial = Versions.getBaseName((ReadGraph)graph, (Resource)entity);
        this.version = Versions.getVersion((ReadGraph)graph, (Resource)entity);
    }

    @Override
    public String getValue() {
        return this.initial;
    }

    private void initialize(ReadGraph graph) throws DatabaseException {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.refreshUsedSiblingNames(graph);
        if (Layer0Utils.isPublished(graph, this.entity)) {
            throw new DatabaseException("Published resources cannot be renamed.");
        }
        if (Layer0Utils.isContainerPublished(graph, this.entity)) {
            throw new DatabaseException("Cannot rename in a published shared library.");
        }
    }

    private void refreshUsedSiblingNames(ReadGraph graph) throws DatabaseException {
        String uri = graph.getPossibleURI(this.entity);
        this.hasUri = uri != null;
        THashMap used = new THashMap();
        for (Resource partOf : graph.getObjects(this.entity, this.L0.PartOf)) {
            Map childMap = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(partOf));
            used.putAll(childMap);
        }
        String originalName = (String)graph.getPossibleValue(this.property, (Binding)Bindings.STRING);
        used.remove(originalName);
        this.namesInUse = used;
    }

    public String finalValue(String value) {
        return this.version != null ? String.valueOf(value) + "@" + this.version : value;
    }

    @Override
    public String isValid(String value_) {
        String value = this.finalValue(value_);
        if (value.isEmpty()) {
            return "Name is empty.";
        }
        if (this.namesInUse.containsKey(value)) {
            return "Name is already used by a sibling.";
        }
        if (this.hasUri && value.startsWith(".")) {
            return "Name of an entity with URI must not begin with a dot ('.')";
        }
        return null;
    }

    @Override
    public final void modify(WriteGraph graph, String value_) throws DatabaseException {
        String value = this.finalValue(value_);
        graph.claimLiteral(this.entity, this.L0.HasName, this.L0.NameOf, (Object)value, (Binding)Bindings.STRING);
    }
}

