/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandlerAdapter;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.adapter.impl.ImportAdvisorFactory;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.layer0.Layer0;

public class DefaultPasteHandler
extends PasteHandlerAdapter {
    protected Resource resource;

    public DefaultPasteHandler(Resource resource) {
        this.resource = resource;
    }

    public static void defaultExecute(TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        TransferableGraphs.importGraph1((Session)SimanticsInternal.getSession(), (TransferableGraph1)tg, (IImportAdvisor)advisor);
    }

    public static void defaultExecute(WriteGraph graph, TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException {
        TransferableGraphs.importGraph1((WriteGraph)graph, (TransferableGraph1)tg, (IImportAdvisor)advisor);
    }

    public void execute(WriteGraph graph, TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException {
        DefaultPasteHandler.defaultExecute(graph, tg, resource, advisor);
    }

    public void onPasteBegin(WriteGraph graph) throws DatabaseException {
    }

    public void onPaste(WriteGraph graph, IImportAdvisor2 advisor, Set<SimanticsClipboard.Representation> representations) throws DatabaseException {
    }

    public void onPasteEnd(WriteGraph graph) throws DatabaseException {
    }

    public IImportAdvisor2 getAdvisor(ReadGraph graph, TransferableGraph1 tg, Resource target, PasteEventHandler handler) throws DatabaseException {
        Collection roots = TransferableGraphUtils.getRoots((TransferableGraph1)tg);
        if (roots.size() == 1) {
            Root root = (Root)((Identity)roots.iterator().next()).definition;
            Resource type = graph.getPossibleResource(root.type);
            ImportAdvisorFactory factory = (ImportAdvisorFactory)graph.getPossibleAdapter(type, ImportAdvisorFactory.class);
            if (factory != null) {
                if (handler != null) {
                    return handler.createAdvisor(graph, factory, target);
                }
                return factory.create(graph, target, Collections.emptyMap());
            }
        }
        return new DefaultPasteImportAdvisor(target);
    }

    public Collection<Resource> pasteObject(WriteGraph graph, Set<SimanticsClipboard.Representation> object, PasteEventHandler handler) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        TransferableGraphSource tgs = (TransferableGraphSource)ClipboardUtils.accept((ReadGraph)graph, object, SimanticsKeys.KEY_TRANSFERABLE_GRAPH_SOURCE);
        if (tgs != null) {
            TransferableGraph1 tg = TransferableGraphs.create((ReadGraph)graph, (TransferableGraphSource)tgs);
            IImportAdvisor2 advisor = this.getAdvisor((ReadGraph)graph, tg, this.resource, handler);
            this.execute(graph, tg, this.resource, (IImportAdvisor)advisor);
            Collection roots = advisor.getRootInfo();
            if (handler != null) {
                for (IImportAdvisor2.RootInfo r : roots) {
                    handler.postProcess(graph, r.resource);
                }
            }
            this.onPaste(graph, advisor, object);
            if (tgs instanceof ModelTransferableGraphSource) {
                ModelTransferableGraphSource mtgs = (ModelTransferableGraphSource)tgs;
                block1: for (TransferableGraphConfiguration2.SeedSpec spec : mtgs.getConfiguration().seeds) {
                    if (TransferableGraphConfiguration2.SeedSpec.SeedSpecType.SPECIAL_ROOT.equals((Object)spec.specType)) continue;
                    for (IImportAdvisor2.RootInfo info : roots) {
                        if (!spec.name.equals(info.root.name)) continue;
                        result.add(info.resource);
                        continue block1;
                    }
                    result.clear();
                    result.addAll(advisor.getRoots());
                    break;
                }
            } else {
                result.addAll(advisor.getRoots());
            }
        }
        return result;
    }

    @Override
    public Collection<Resource> pasteFromClipboard(WriteGraph graph, SimanticsClipboard clipboard, PasteEventHandler handler) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        this.checkIfRootAllowsPaste((ReadGraph)graph);
        Map<String, Resource> hints = Collections.singletonMap(ClipboardUtils.HINT_TARGET_RESOURCE, this.resource);
        this.onPasteBegin(graph);
        HashSet cuts = new HashSet();
        for (Set<SimanticsClipboard.Representation> object : clipboard.getContents()) {
            Collection cut = (Collection)ClipboardUtils.accept(object, SimanticsKeys.KEY_CUT_RESOURCES);
            TransferableGraphSource tg = (TransferableGraphSource)ClipboardUtils.accept((ReadGraph)graph, object, SimanticsKeys.KEY_TRANSFERABLE_GRAPH_SOURCE, hints);
            if (tg != null) {
                result.addAll(this.pasteObject(graph, object, handler));
                if (cut == null) continue;
                cuts.addAll(cut);
                continue;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Resource r : cut) {
                graph.deny(r, L0.PartOf);
                graph.claim(this.resource, L0.ConsistsOf, L0.PartOf, r);
                result.add(r);
            }
        }
        this.onPasteEnd(graph);
        if (!cuts.isEmpty()) {
            for (Resource cut : cuts) {
                RemoverUtil.remove(graph, cut);
            }
        }
        return result;
    }

    protected void checkIfRootAllowsPaste(ReadGraph graph) throws DatabaseException {
        if (this.resource == null) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Boolean published = (Boolean)graph.getPossibleRelatedValue(this.resource, L0.Entity_published);
        if (published != null && published.booleanValue()) {
            throw new DatabaseException("Target resource " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.resource) + " is published and does not allow paste.");
        }
    }

    public Object getAdapter(Class adapter) {
        if (Resource.class == adapter) {
            return this.resource;
        }
        return null;
    }
}

