package org.simantics.db.layer0.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

public class TGRepresentation implements Representation {

	protected boolean ignoreVirtualResources = false;
	protected Resource[] resources;
	private TransferableGraph1 value = null;
	private TransferableGraphConfiguration2 configuration;
	
	public TGRepresentation(Resource ... resources) {
		this.resources = resources;
	}

	public TGRepresentation(boolean ignoreVirtualResources, Resource ... resources) {
		this.ignoreVirtualResources = ignoreVirtualResources;
		this.resources = resources;
	}

	public TGRepresentation(TransferableGraphConfiguration2 configuration) {
		this.configuration = configuration;
	}

	public TGRepresentation(TransferableGraph1 value) {
		this.value = value;
	}

	@Override
	public Key getKey() {
		return SimanticsKeys.KEY_TRANSFERABLE_GRAPH;
	}
	
	public TransferableGraph1 compute(ReadGraph graph, Map<String,Object> hints) throws DatabaseException {
		
		if(configuration == null) {
			configuration = new TransferableGraphConfiguration2(graph, Arrays.asList(resources), ignoreVirtualResources, false);
			configuration.exclusionFunction = TGRepresentationUtils.computeExclusionFunction(graph, resources, hints);
		}
		
		try (ModelTransferableGraphSource source = graph.syncRequest(new ModelTransferableGraphSourceRequest(configuration))) {
			return TransferableGraphs.create(graph, source);
		} catch (IOException e) {
			throw new DatabaseException(e);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <T> T getValue(RequestProcessor processor, Map<String,Object> hints) throws DatabaseException {
		
		if(value == null) {

			value = processor.syncRequest(new UniqueRead<TransferableGraph1>() {

				@Override
				public TransferableGraph1 perform(ReadGraph graph) throws DatabaseException {
					return compute(graph, hints);
				}

			});

		}
		
		return (T)value;
		
	}
	
}