package org.simantics.db.layer0.request;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * Returns a set of active models.
 * 
 * @author Tuukka Lehtonen
 */
public class ActiveModels extends ResourceRead<Collection<Resource>> {

    public ActiveModels(Resource project) {
        super(project);
    }

    @Override
    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        Layer0X L0X = Layer0X.getInstance(graph);
        SimulationResource SIMU = SimulationResource.getInstance(graph);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource model : graph.syncRequest(new ObjectsWithType(resource, L0.ConsistsOf, SIMU.Model))) {
            if (graph.hasStatement(model, L0X.IsActivatedBy))
                result.add(model);
        }
        return result;
    }
    
    public static Resource getPossibleActiveModel(ReadGraph graph, Resource project) throws DatabaseException {
        Collection<Resource> models = graph.syncRequest(new ActiveModels(project));
        if(models.isEmpty())
            return null;
        else
            return models.iterator().next();
    }

}
