/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.internal;

import java.io.File;

import org.eclipse.core.runtime.Platform;
import org.simantics.db.Resource;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.management.ISessionContext;

/**
 * An internal facade for accessing basic Simantics platform services.
 * Usable without a graphical UI, i.e. in headless contexts.
 * 
 * Use org.simantics.Simantics instead where ever possible.
 */
public class SimanticsInternal extends org.simantics.db.common.SimanticsInternal {

    /**
     * @return the currently open and active project as an IProject
     * @throws IllegalStateException if there is no currently active database
     *         session, which also means there is no active project at the
     *         moment
     */
    public static Resource getProject() {
        ISessionContext ctx = getSessionContext();
        if (ctx == null)
            throw new IllegalStateException("No current database session");
        return ctx.getHint(SimanticsKeys.KEY_PROJECT);
    }

    /**
     * @return the currently open and active project as an IProject or null if
     *         there is either no project or no active database session
     */
    public static Resource peekProject() {
        ISessionContext ctx = getSessionContext();
        return ctx != null ? (Resource) ctx.getHint(SimanticsKeys.KEY_PROJECT) : null;
    }

    private static SimanticsClipboard clipboard = SimanticsClipboard.EMPTY;

    /**
     * @param content
     */
    public static void setClipboard(SimanticsClipboard content) {
        if (content == null)
            throw new NullPointerException("null clipboard content");
        clipboard = content;
    }

    public static SimanticsClipboard getClipboard() {
        return clipboard;
    }

    public static File getTemporaryDirectory() {
        File workspace = Platform.getLocation().toFile();
        File temp = new File(workspace, "tempFiles");
        temp.mkdirs();
        return temp;
    }
    
}
