package org.simantics.db.layer0.changeset;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.DependencyChanges.Change;

public interface ChangeVisitor {
    /**
     * {@link MetadataUtils#visitDependencyChangesBetween}
     * calls this method for every change found between given range.
     * The flag {@code inverted} tells whether the change is actually
     * undone instead of done.
     */
    void visit(ReadGraph graph, Change change, boolean inverted) throws DatabaseException;
}
