/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter;

import org.simantics.db.ComputationalValue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.reflection.ReflectionUtils;
import org.simantics.scl.reflection.ValueNotFoundException;

/**
 * @author Antti Villberg
 * @since 1.36.0
 */
public class ReflectionComputationalValue implements ComputationalValue {

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getValue(ReadGraph graph, Resource resource) throws DatabaseException {
        try {
            return (T)ReflectionUtils.getValue(graph.getURI(resource)).getValue();
        } catch(ValueNotFoundException e) {
            throw new DatabaseException(e);
        } catch(ClassCastException e) {
            throw new DatabaseException(e);
        }
    }

}
