/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.pattern.PatternReplaceFilter;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.Version;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.indexing.IndexSchema;
import org.simantics.utils.datastructures.Pair;

public class Queries {
    private static AtomicReference<Pair<Query, String>> queryCache = new AtomicReference();
    static final PerFieldAnalyzerWrapper analyzer = Queries.createAnalyzer();

    static PerFieldAnalyzerWrapper createAnalyzer() {
        HashMap<String, Object> analyzerPerField = new HashMap<String, Object>();
        analyzerPerField.put("Model", new KeywordAnalyzer());
        analyzerPerField.put("Parent", new KeywordAnalyzer());
        analyzerPerField.put("Resource", new KeywordAnalyzer());
        analyzerPerField.put("GUID", new KeywordAnalyzer());
        analyzerPerField.put("Name", new KeywordAnalyzer());
        analyzerPerField.put("Types", (Object)new TypeStringAnalyzer(false));
        analyzerPerField.put("NameSearch", (Object)new LowerCaseWhitespaceAnalyzer(Version.LUCENE_4_9));
        analyzerPerField.put("TypesSearch", (Object)new TypeStringAnalyzer(true));
        analyzerPerField.put("TypeId", new WhitespaceAnalyzer(Version.LUCENE_4_9));
        PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new LowerCaseWhitespaceAnalyzer(Version.LUCENE_4_9), analyzerPerField);
        return analyzer;
    }

    static PerFieldAnalyzerWrapper getAnalyzer() {
        return analyzer;
    }

    static Query parse(String search, IndexSchema schema) throws ParseException {
        Pair<Query, String> cachedQuery = queryCache.get();
        if (cachedQuery != null && search.equals(cachedQuery.second)) {
            return (Query)cachedQuery.first;
        }
        CustomQueryParser parser = new CustomQueryParser(Version.LUCENE_4_9, "Name", (Analyzer)Queries.getAnalyzer(), schema);
        parser.setLowercaseExpandedTerms(false);
        Query query = parser.parse(search);
        queryCache.set((Pair<Query, String>)Pair.make((Object)query, (Object)search));
        return query;
    }

    public static class CustomQueryParser
    extends QueryParser {
        protected final IndexSchema schema;

        public CustomQueryParser(Version version, String field, Analyzer analyzer, IndexSchema schema) {
            super(version, field, analyzer);
            this.schema = schema;
            this.setAllowLeadingWildcard(true);
        }

        protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
            IndexSchema.Type type = this.schema.typeMap.get(field);
            if (IndexSchema.NUMERIC_TYPES.contains((Object)type)) {
                boolean equalParts = ObjectUtils.objectEquals((Object)part1, (Object)part2);
                try {
                    switch (type) {
                        case INT: {
                            Integer min;
                            Integer n = min = part1 != null ? Integer.valueOf(part1) : null;
                            Integer max = part2 != null ? (equalParts ? min : Integer.valueOf(part2)) : null;
                            return NumericRangeQuery.newIntRange((String)field, (Integer)min, (Integer)max, (boolean)startInclusive, (boolean)endInclusive);
                        }
                        case LONG: {
                            Long min;
                            Long l = min = part1 != null ? Long.valueOf(part1) : null;
                            Long max = part2 != null ? (equalParts ? min : Long.valueOf(part2)) : null;
                            return NumericRangeQuery.newLongRange((String)field, (Long)min, (Long)max, (boolean)startInclusive, (boolean)endInclusive);
                        }
                        case FLOAT: {
                            Float min;
                            Float f = min = part1 != null ? Float.valueOf(part1) : null;
                            Float max = part2 != null ? (equalParts ? min : Float.valueOf(part2)) : null;
                            return NumericRangeQuery.newFloatRange((String)field, (Float)min, (Float)max, (boolean)startInclusive, (boolean)endInclusive);
                        }
                        case DOUBLE: {
                            Double min;
                            Double d = min = part1 != null ? Double.valueOf(part1) : null;
                            Double max = part2 != null ? (equalParts ? min : Double.valueOf(part2)) : null;
                            return NumericRangeQuery.newDoubleRange((String)field, (Double)min, (Double)max, (boolean)startInclusive, (boolean)endInclusive);
                        }
                    }
                    throw new ParseException("Unrecognized numeric field type '" + (Object)((Object)type) + "' for field '" + field + "'");
                }
                catch (NumberFormatException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            return super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
        }
    }

    static final class LowerCaseWhitespaceAnalyzer
    extends Analyzer {
        private final Version matchVersion;

        public LowerCaseWhitespaceAnalyzer(Version matchVersion) {
            this.matchVersion = matchVersion;
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
            return new Analyzer.TokenStreamComponents((Tokenizer)new LowerCaseWhitespaceTokenizer(this.matchVersion, reader));
        }
    }

    static final class LowerCaseWhitespaceTokenizer
    extends CharTokenizer {
        public LowerCaseWhitespaceTokenizer(Version matchVersion, Reader in) {
            super(matchVersion, in);
        }

        public LowerCaseWhitespaceTokenizer(Version matchVersion, AttributeFactory factory, Reader in) {
            super(matchVersion, factory, in);
        }

        protected int normalize(int c) {
            return Character.toLowerCase(c);
        }

        protected boolean isTokenChar(int c) {
            return !Character.isWhitespace(c);
        }
    }

    static final class LowercaseFilter
    extends TokenFilter {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

        public LowercaseFilter(TokenStream in) {
            super(in);
        }

        public boolean incrementToken() throws IOException {
            if (!this.input.incrementToken()) {
                return false;
            }
            String lowercase = this.termAtt.toString().toLowerCase();
            this.termAtt.setEmpty().append(lowercase);
            return true;
        }
    }

    static final class TypeStringAnalyzer
    extends Analyzer {
        private boolean lowercase;

        public TypeStringAnalyzer(Boolean lowercase) {
            this.lowercase = lowercase;
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
            PatternTokenizer tokenizer = new PatternTokenizer(reader, Pattern.compile("(([^\\\\ ]|\\\\\\\\|\\\\ )+)( *)"), 1);
            PatternReplaceFilter filter = new PatternReplaceFilter((TokenStream)tokenizer, Pattern.compile("(\\\\(\\\\| ))"), "$2", true);
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)(this.lowercase ? new LowercaseFilter((TokenStream)filter) : filter));
        }
    }
}

