/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.Adapt;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.db.indexing.ImmutableIndexedRelationsSearcher;
import org.simantics.db.indexing.IndexedRelationsMemorySearcher;
import org.simantics.db.indexing.IndexedRelationsSearcher;
import org.simantics.db.indexing.IndexedRelationsSearcherBase;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.request.ReadInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryIndexing {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryIndexing.class);
    private final Session session;
    final Map<String, Map<String, List<Map<String, Object>>>> persistentCache = new ConcurrentHashMap<String, Map<String, List<Map<String, Object>>>>();
    final Map<String, Map<String, List<Resource>>> persistentCacheResources = new ConcurrentHashMap<String, Map<String, List<Resource>>>();
    private final ConcurrentHashMap<String, RAMDirectory> directories = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IndexedRelationsSearcherBase> immutableSearchers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IndexedRelationsSearcher> searchers = new ConcurrentHashMap();

    public MemoryIndexing(Session session) {
        this.session = session;
    }

    protected Path getIndexDirectory(Resource relation, Resource input) {
        return DatabaseIndexing.getIndexLocation(this.session, relation, input);
    }

    public IndexedRelationsSearcher get(RequestProcessor processor, Resource relation, Resource input) {
        Path location = this.getIndexDirectory(relation, input);
        String key = location.toAbsolutePath().toString();
        return this.searchers.computeIfAbsent(key, t -> {
            try {
                GenericRelation r = (GenericRelation)processor.sync((ReadInterface)new Adapt(relation, GenericRelation.class));
                return new IndexedRelationsSearcher(processor, relation, input, r);
            }
            catch (Exception e) {
                LOGGER.error("Could not get searcher for relation {} and input {} in location {}", new Object[]{relation, input, location, e});
                return null;
            }
        });
    }

    public IndexedRelationsSearcherBase getImmutable(RequestProcessor processor, Resource relation, Resource input) {
        Path location = this.getIndexDirectory(relation, input);
        String key = location.toAbsolutePath().toString();
        return this.immutableSearchers.computeIfAbsent(key, t -> {
            try {
                return new ImmutableIndexedRelationsSearcher(processor, relation, input);
            }
            catch (Exception e) {
                LOGGER.error("Could not get searcher base for relation {} and input {} in location {}", new Object[]{relation, input, location, e});
                return null;
            }
        });
    }

    public static MemoryIndexing getInstance(Session session) {
        MemoryIndexing ret = (MemoryIndexing)session.peekService(MemoryIndexing.class);
        if (ret == null) {
            ret = new MemoryIndexing(session);
            session.registerService(MemoryIndexing.class, (Object)ret);
        }
        return ret;
    }

    public Directory getDirectory(String path, Analyzer analyzer) throws IOException {
        try {
            return (Directory)this.directories.computeIfAbsent(path, t -> {
                try {
                    RAMDirectory directory = new RAMDirectory();
                    IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_4_9, analyzer);
                    new IndexWriter((Directory)directory, config.setOpenMode(IndexWriterConfig.OpenMode.CREATE)).close();
                    return directory;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            throw (IOException)e.getCause();
        }
    }

    public void remove(String path) {
        this.directories.remove(path);
    }

    public void flush(IProgressMonitor progress) throws Exception {
        long startTime = System.currentTimeMillis();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        Collection<IndexedRelationsSearcher> searcherEntries = this.searchers.values();
        Collection<IndexedRelationsSearcherBase> immutableSearcherEntries = this.immutableSearchers.values();
        int count = searcherEntries.size() + immutableSearcherEntries.size();
        Semaphore sema = new Semaphore(0);
        ((Stream)Stream.concat(searcherEntries.stream(), immutableSearcherEntries.stream()).parallel()).forEach(base -> {
            try {
                if (base.isIndexAvailable() && base instanceof IndexedRelationsSearcher) {
                    IndexedRelationsMemorySearcher searcher = ((IndexedRelationsSearcher)base).cache;
                    try {
                        List<Object[]> os = searcher.allDocs((IProgressMonitor)monitor, this.session);
                        ((IndexedRelationsSearcher)base).applyChanges((IProgressMonitor)monitor, this.session, searcher.r, os);
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not flush", (Throwable)e);
                    }
                }
                monitor.worked(1);
                base.changeState((IProgressMonitor)monitor, this.session, IndexedRelationsSearcherBase.State.READY);
            }
            finally {
                sema.release();
            }
        });
        sema.acquire(count);
        long totalTime = System.currentTimeMillis() - startTime;
        LOGGER.info("index flush " + totalTime);
    }
}

