/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.RelationInfo;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.procedure.TripleIntProcedureAdapter;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CollectionBinaryQuery;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.procedure.ListenerBase;

public final class Statements
extends CollectionBinaryQuery<TripleIntProcedure>
implements TripleIntProcedure {
    static final TripleIntProcedure NOPT = new TripleIntProcedure(){

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }

        @Override
        public void execute(ReadGraphImpl graph, int s, int p, int o) {
        }

        @Override
        public void finished(ReadGraphImpl graph) {
        }
    };
    static final InternalProcedure<IntSet> NOP = new InternalProcedure<IntSet>(){

        @Override
        public void execute(ReadGraphImpl graph, IntSet result) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };

    public Statements(int r1, int r2) {
        super(r1, r2);
    }

    public static final void queryEach(ReadGraphImpl graph, int r1, int r2, QueryProcessor provider, CacheEntry parent, ListenerBase listener, TripleIntProcedure procedure) throws DatabaseException {
        assert (r1 != 0);
        assert (r2 != 0);
        if (parent == null && listener == null) {
            Statements.computeForEach(graph, r1, r2, null, procedure);
            return;
        }
        QueryCache.runnerStatements(graph, r1, r2, parent, listener, procedure);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    private static final IntArray getAssertionMap(ReadGraphImpl graph, int r1, int r2, Statements entry) throws DatabaseException {
        class AssertionMapProc
        implements IntProcedure {
            boolean first = true;
            private IntArray result;
            private final /* synthetic */ int val$r2;
            private final /* synthetic */ Statements val$entry;

            AssertionMapProc(int n, Statements statements) {
                this.val$r2 = n;
                this.val$entry = statements;
            }

            public void addStatement(int s, int p, int o) {
                if (this.result.size() == 0) {
                    this.result.add(s);
                    this.result.add(p);
                    this.result.add(o);
                } else {
                    int i = 0;
                    while (i < this.result.sizeOrData) {
                        int existingO;
                        int existingP = this.result.data[i + 1];
                        if (p == existingP && (existingO = this.result.data[i + 2]) == o) {
                            return;
                        }
                        i += 3;
                    }
                    this.result.add(s);
                    this.result.add(p);
                    this.result.add(o);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int type) throws DatabaseException {
                if (this.result == null) {
                    this.result = QueryCache.resultAssertedStatements(graph, type, this.val$r2, this.val$entry, null);
                } else {
                    int i;
                    IntArray ia;
                    if (this.first) {
                        ia = this.result;
                        this.result = new IntArray();
                        if (ia.data != null) {
                            i = 0;
                            while (i < ia.sizeOrData) {
                                this.addStatement(ia.data[i], ia.data[i + 1], ia.data[i + 2]);
                                i += 3;
                            }
                        }
                        this.first = false;
                    }
                    ia = QueryCache.resultAssertedStatements(graph, type, this.val$r2, this.val$entry, null);
                    if (ia.data != null) {
                        i = 0;
                        while (i < ia.sizeOrData) {
                            this.addStatement(ia.data[i], ia.data[i + 1], ia.data[i + 2]);
                            i += 3;
                        }
                    }
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable throwable) {
            }
        }
        AssertionMapProc amp = new AssertionMapProc(r2, entry);
        QueryCache.runnerPrincipalTypes(graph, r1, entry, null, amp);
        return amp.result;
    }

    private static final void forSingleAssertion(ReadGraphImpl graph, int r1, int r2, Statements parent, TripleIntProcedure procedure) throws DatabaseException {
        IntArray map = Statements.getAssertionMap(graph, r1, r2, parent);
        if (map == null) {
            procedure.finished(graph);
            return;
        }
        int size = map.size();
        if (size == 3) {
            int s = map.data[0];
            int p = map.data[1];
            int o = map.data[2];
            procedure.execute(graph, s, p, o);
            procedure.finished(graph);
        } else if (size == 0) {
            procedure.finished(graph);
        } else {
            int candidateS = map.data[0];
            int candidateP = map.data[1];
            int candidateO = map.data[2];
            IntSet candidateIs = null;
            try {
                candidateIs = QueryCache.resultSuperTypes(graph, candidateS, parent, null);
            }
            catch (DatabaseException e) {
                procedure.exception(graph, e);
                return;
            }
            int i = 3;
            while (i < map.size()) {
                int nextS = map.data[i];
                int nextP = map.data[i + 1];
                int nextO = map.data[i + 2];
                if (nextS != candidateS && !candidateIs.contains(nextS)) {
                    IntSet nextIs = null;
                    try {
                        nextIs = QueryCache.resultSuperTypes(graph, nextS, parent, null);
                    }
                    catch (DatabaseException e) {
                        procedure.exception(graph, e);
                        return;
                    }
                    if (nextIs.contains(candidateS)) {
                        candidateS = nextS;
                        candidateP = nextP;
                        candidateO = nextO;
                        candidateIs = nextIs;
                    } else {
                        ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has conflicting assertions.", r1);
                        procedure.exception(graph, exception);
                        return;
                    }
                }
                i += 3;
            }
            procedure.execute(graph, candidateS, candidateP, candidateO);
            procedure.finished(graph);
        }
    }

    public static final void computeFunctionalIndex(ReadGraphImpl graph, final int r1, final int r2, final Statements parent, RelationInfo ri, final TripleIntProcedure procedure) throws DatabaseException {
        if (ri.isFinal) {
            int result = graph.processor.querySupport.getFunctionalObject(r1, r2);
            if (result == 0) {
                Statements.forSingleAssertion(graph, r1, r2, parent, procedure);
            } else if (result == -1) {
                graph.processor.querySupport.getObjects(graph, r1, r2, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                        procedure.execute(graph, r1, r2, i);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                    }
                });
                Statements.forSingleAssertion(graph, r1, r2, parent, procedure);
            } else {
                procedure.execute(graph, r1, r2, result);
                procedure.finished(graph);
            }
        } else {
            IntSet direct = QueryCache.resultDirectPredicates(graph, r1, null, null);
            direct.forEach(graph, new SyncIntProcedure(){
                int found = 0;

                @Override
                public void run(ReadGraphImpl graph) throws DatabaseException {
                    if (this.found == 1) {
                        procedure.finished(graph);
                    } else if (this.found == 0) {
                        Statements.forSingleAssertion(graph, r1, r2, parent, procedure);
                    }
                }

                @Override
                public void execute(ReadGraphImpl graph, final int pred) throws DatabaseException {
                    if (this.found > 0) {
                        return;
                    }
                    if (pred == r2) {
                        QueryCache.runnerDirectObjects(graph, r1, pred, null, null, new IntProcedure(){

                            @Override
                            public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                                if (found == 0) {
                                    procedure.execute(graph, r1, pred, i);
                                    found = 1;
                                } else {
                                    ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one statement.", r1);
                                    procedure.exception(graph, exception);
                                    found = 2;
                                }
                            }

                            @Override
                            public void finished(ReadGraphImpl graph) throws DatabaseException {
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                procedure.exception(graph, t);
                                found = 2;
                            }
                        });
                    } else {
                        QueryCache.runnerSuperRelations(graph, pred, parent, null, new InternalProcedure<IntSet>(){

                            @Override
                            public void execute(ReadGraphImpl graph, IntSet result) throws DatabaseException {
                                if (found > 0) {
                                    return;
                                }
                                if (result.contains(r2)) {
                                    this.inc();
                                    QueryCache.runnerDirectObjects(graph, r1, pred, null, null, new IntProcedure(){

                                        @Override
                                        public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                                            if (found == 0) {
                                                procedure.execute(graph, r1, pred, i);
                                                found = 1;
                                            } else {
                                                ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one statement (r1=" + r1 + ", r2=" + r2 + ").", r1);
                                                procedure.exception(graph, exception);
                                                found = 2;
                                            }
                                        }

                                        @Override
                                        public void finished(ReadGraphImpl graph) throws DatabaseException {
                                        }

                                        @Override
                                        public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                            procedure.exception(graph, t);
                                            found = 2;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                procedure.exception(graph, t);
                                found = 2;
                            }
                        });
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) throws DatabaseException {
                    this.dec(graph);
                }
            });
        }
    }

    private static final void forAssertions(ReadGraphImpl graph, int r1, final int r2, final Statements parent, final TripleIntProcedure procedure) throws DatabaseException {
        QueryCache.runnerPrincipalTypes(graph, r1, parent, null, new SyncIntProcedure(){
            TripleIntProcedure proc;
            {
                this.proc = new TripleIntProcedureAdapter(){

                    @Override
                    public void execute(ReadGraphImpl graph, int s, int p, int o) throws DatabaseException {
                        tripleIntProcedure.execute(graph, s, p, o);
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) throws DatabaseException {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        this.dec(graph);
                        tripleIntProcedure.exception(graph, t);
                    }
                };
            }

            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
                procedure.finished(graph);
            }

            @Override
            public void execute(ReadGraphImpl graph, int type) throws DatabaseException {
                this.inc();
                QueryCache.runnerAssertedStatements(graph, type, r2, parent, null, this.proc);
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                this.dec(graph);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                this.dec(graph);
            }
        });
    }

    public static final void computeNotFunctionalIndex(ReadGraphImpl graph, final int r1, final int r2, final Statements parent, RelationInfo ri, final TripleIntProcedure procedure) throws DatabaseException {
        if (ri.isFinal) {
            graph.processor.querySupport.getObjects(graph, r1, r2, new IntProcedure(){

                @Override
                public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                    procedure.execute(graph, r1, r2, i);
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                    procedure.exception(graph, t);
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                }
            });
            if (ri.isAsserted) {
                Statements.forAssertions(graph, r1, r2, parent, procedure);
            } else {
                procedure.finished(graph);
            }
        } else {
            IntSet direct = QueryCache.resultDirectPredicates(graph, r1, null, null);
            direct.forEach(graph, new SyncIntProcedure(){

                @Override
                public void run(ReadGraphImpl graph) throws DatabaseException {
                    Statements.forAssertions(graph, r1, r2, parent, procedure);
                }

                @Override
                public void execute(ReadGraphImpl graph, final int pred2) throws DatabaseException {
                    if (pred2 == r2) {
                        QueryCache.runnerDirectObjects(graph, r1, pred2, null, null, new IntProcedure(){

                            @Override
                            public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                                procedure.execute(graph, r1, pred2, i);
                            }

                            @Override
                            public void finished(ReadGraphImpl graph) throws DatabaseException {
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                procedure.exception(graph, t);
                            }
                        });
                    } else {
                        try {
                            IntSet result = QueryCache.resultSuperRelations(graph, pred2, parent, null);
                            if (result.contains(r2)) {
                                this.inc();
                                QueryCache.runnerDirectObjects(graph, r1, pred2, null, null, new IntProcedure(){

                                    @Override
                                    public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                                        procedure.execute(graph, r1, pred2, i);
                                    }

                                    @Override
                                    public void finished(ReadGraphImpl graph) throws DatabaseException {
                                        this.dec(graph);
                                    }

                                    @Override
                                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                        procedure.exception(graph, t);
                                        this.dec(graph);
                                    }
                                });
                            }
                        }
                        catch (Throwable e) {
                            procedure.exception(graph, e);
                        }
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) throws DatabaseException {
                    this.dec(graph);
                }
            });
        }
    }

    public static void computeForEach(ReadGraphImpl graph, int r1, int r2, Statements entry, TripleIntProcedure procedure_) throws DatabaseException {
        TripleIntProcedure procedure = entry != null ? entry : procedure_;
        RelationInfo ri = QueryCache.resultRelationInfoQuery(graph, r2, entry, null);
        graph.ensureLoaded(r1, r2);
        if (ri.isFunctional) {
            Statements.computeFunctionalIndex(graph, r1, r2, entry, ri, procedure);
        } else {
            Statements.computeNotFunctionalIndex(graph, r1, r2, entry, ri, procedure);
        }
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
    }

    public String toString() {
        return "Statements[" + this.r1() + " - " + this.r2() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finish(ReadGraphImpl graph, TripleIntProcedure procedure) throws DatabaseException {
        assert (this.assertPending());
        Statements statements = this;
        synchronized (statements) {
            this.setReady();
        }
        IntArray cfr_ignored_0 = (IntArray)this.getResult();
        IntArray value = (IntArray)this.getResult();
        int i = 0;
        while (i < value.size()) {
            procedure.execute(graph, value.data[i], value.data[i + 1], value.data[i + 2]);
            i += 3;
        }
        procedure.finished(graph);
    }

    public synchronized void addOrSet(int s, int p, int o) {
        assert (this.assertPending());
        IntArray value = (IntArray)this.getResult();
        value.add(s);
        value.add(p);
        value.add(o);
    }

    public static final int r1(long id) {
        return (int)(id >>> 32);
    }

    public static final int r2(long id) {
        return (int)id;
    }

    public final void addOrSetFunctional(int s, long po) {
        this.addOrSetFunctional(s, Statements.r1(po), Statements.r2(po));
    }

    public final void addOrSetFunctional(int s, int p, int o) {
        assert (this.assertPending());
        IntArray value = (IntArray)this.getResult();
        value.add(s);
        value.add(p);
        value.add(o);
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, TripleIntProcedure procedure) throws DatabaseException {
        assert (this.isReady());
        IntArray value = (IntArray)this.getResult();
        if (this.handleException(graph, procedure)) {
            return value;
        }
        int i = 0;
        while (i < value.size()) {
            procedure.execute(graph, value.data[i], value.data[i + 1], value.data[i + 2]);
            i += 3;
        }
        procedure.finished(graph);
        return value;
    }

    @Override
    public void recompute(ReadGraphImpl graph) throws DatabaseException {
        Statements.computeForEach(graph, this.r1(), this.r2(), this, new TripleIntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                new Error("Error in recompute.", t).printStackTrace();
            }
        });
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.r1());
    }

    @Override
    public void execute(ReadGraphImpl graph, int s, int p, int o) throws DatabaseException {
        this.addOrSet(s, p, o);
    }

    @Override
    public void finished(ReadGraphImpl graph) throws DatabaseException {
        this.setReady();
    }

    @Override
    public void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
        this.except(throwable);
    }
}

