/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.db.ResourceSet;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.support.ResourceSupport;

public final class IntSet
implements ResourceSet {
    private final ResourceSupport support;
    public int[] data;
    public int sizeOrData;
    protected static final int DEFAULT_CAPACITY = 3;
    public static final int NO_DATA = -1;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    public static IntSet EMPTY = new IntSet();

    private IntSet() {
        this.support = null;
    }

    public IntSet(QuerySupport support) {
        this.support = support.getSupport();
        this.data = null;
        this.sizeOrData = -1;
    }

    public IntSet(QuerySupport support, int value) {
        this.support = support.getSupport();
        this.data = null;
        this.sizeOrData = value;
    }

    public int hashCode() {
        return 31 * this.sizeOrData + 41 * Arrays.hashCode(this.data);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (IntSet.class != object.getClass()) {
            return false;
        }
        IntSet r = (IntSet)object;
        return this.sizeOrData == r.sizeOrData && Arrays.equals(this.data, r.data);
    }

    public int size() {
        return this.data != null ? this.sizeOrData : (this.sizeOrData != -1 ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.sizeOrData == -1;
    }

    public boolean add(int val) {
        if (this.data == null) {
            if (this.sizeOrData == val) {
                return false;
            }
            if (this.sizeOrData == -1) {
                this.sizeOrData = val;
                return true;
            }
            this.data = new int[3];
            this.data[0] = this.sizeOrData;
            this.data[1] = val;
            this.sizeOrData = 2;
            return true;
        }
        int i = 0;
        while (i < this.sizeOrData) {
            if (this.data[i] == val) {
                return false;
            }
            ++i;
        }
        if (this.data.length == this.sizeOrData) {
            int newCap = this.data.length << 1;
            int[] tmp = new int[newCap];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
            this.data[this.sizeOrData++] = val;
        } else {
            this.data[this.sizeOrData++] = val;
        }
        return true;
    }

    public void forEach(TIntProcedure proc) {
        if (this.data == null) {
            if (this.sizeOrData != -1) {
                proc.execute(this.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < this.sizeOrData) {
                proc.execute(this.data[i]);
                ++i;
            }
        }
    }

    public boolean contains(int val) {
        if (this.data == null) {
            return this.sizeOrData == val;
        }
        int i = 0;
        while (i < this.sizeOrData) {
            if (this.data[i] == val) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void trim() {
        if (this.data != null && this.sizeOrData < this.data.length) {
            int newCap = this.sizeOrData;
            int[] tmp = new int[newCap];
            System.arraycopy(this.data, 0, tmp, 0, newCap);
            this.data = tmp;
            this.sizeOrData = newCap;
        }
    }

    public boolean add(Resource e) {
        return this.add(((ResourceImpl)e).id);
    }

    public boolean addAll(Collection<? extends Resource> c) {
        boolean ret = false;
        for (Resource resource : c) {
            if (!this.add(resource)) continue;
            ret = true;
        }
        return ret;
    }

    public void clear() {
        this.sizeOrData = -1;
        this.data = null;
    }

    public boolean contains(Object o) {
        assert (o != null);
        return this.contains(((ResourceImpl)o).id);
    }

    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Iterator<Resource> iterator() {
        class ArraySetIterator
        implements Iterator<Resource> {
            int next = 0;

            ArraySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.next < IntSet.this.size();
            }

            @Override
            public Resource next() {
                if (IntSet.this.size() == 1) {
                    ++this.next;
                    return new ResourceImpl(IntSet.this.support, IntSet.this.sizeOrData);
                }
                return new ResourceImpl(IntSet.this.support, IntSet.this.data[this.next++]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new ArraySetIterator();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        if (this.data != null) {
            Object[] result = new Object[this.sizeOrData];
            int i = 0;
            while (i < this.sizeOrData) {
                result[i] = new ResourceImpl(this.support, this.data[i]);
                ++i;
            }
            return result;
        }
        if (this.sizeOrData == -1) {
            return EMPTY_ARRAY;
        }
        return new Object[]{new ResourceImpl(this.support, this.sizeOrData)};
    }

    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "IntSet " + this.sizeOrData + " " + Arrays.toString(this.data);
    }

    public boolean disjoint(Set<Resource> other) {
        if (other instanceof ResourceSet) {
            ResourceSet rs = (ResourceSet)other;
            if (this.data == null) {
                return !rs.contains(this.sizeOrData);
            }
            int i = 0;
            while (i < this.sizeOrData) {
                if (rs.contains(this.data[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (this.data == null) {
            return !other.contains(this.sizeOrData);
        }
        int i = 0;
        while (i < this.sizeOrData) {
            if (other.contains(this.data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void forEach(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        if (this.data != null) {
            int i = 0;
            while (i < this.sizeOrData) {
                procedure.execute(graph, this.data[i]);
                ++i;
            }
        } else if (this.sizeOrData != -1) {
            procedure.execute(graph, this.sizeOrData);
        }
        procedure.finished(graph);
    }
}

