/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.RelationInfo;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryCacheBase;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.UnaryQuery;

public final class AssertedPredicates
extends UnaryQuery<IntProcedure> {
    AssertedPredicates(int r) {
        super(r);
    }

    public static AssertedPredicates newInstance(int r) {
        return new AssertedPredicates(r);
    }

    @Override
    public final void clearResult(QuerySupport support) {
        this.setResult(new IntArray());
    }

    @Override
    public final void setReady() {
        super.setReady();
        IntArray v = (IntArray)this.getResult();
        int size = v.size();
        if (size == 0) {
            this.setResult(IntArray.EMPTY);
        } else {
            v.trim();
        }
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    void computeInheritedAssertions(ReadGraphImpl graph, int type, IntProcedure proc) throws DatabaseException {
        QueryProcessor processor = graph.processor;
        QueryCache.runnerDirectObjects(graph, type, processor.getInherits(), this, null, new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) {
            }

            @Override
            public void execute(ReadGraphImpl graph, int inh) throws DatabaseException {
                this.inc();
                QueryCache.runnerAssertedPredicates(graph, inh, AssertedPredicates.this, null, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int ass) {
                        AssertedPredicates.this.addOrSet(ass);
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) throws DatabaseException {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                this.dec(graph);
            }
        });
    }

    public Object compute(ReadGraphImpl graph, IntProcedure proc) throws DatabaseException {
        final QueryProcessor processor = graph.processor;
        this.computeInheritedAssertions(graph, this.id, proc);
        QueryCache.runnerDirectObjects(graph, this.id, processor.getAsserts(), this, null, new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int ass) throws DatabaseException {
                QueryCache.runnerDirectObjects(graph, ass, processor.getHasPredicate(), AssertedPredicates.this, null, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int pred) throws DatabaseException {
                        AssertedPredicates.this.addOrSetHiding(graph, pred, AssertedPredicates.this);
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
            }
        });
        this.finish(graph, processor);
        this.performFromCache(graph, proc);
        return this.getResult();
    }

    public String toString() {
        return "AssertedPredicates[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finish(ReadGraphImpl graph, QueryProcessor provider) {
        assert (!this.isReady());
        AssertedPredicates assertedPredicates = this;
        synchronized (assertedPredicates) {
            this.setReady();
        }
    }

    private synchronized void addOrSet(int add) {
        assert (this.isPending());
        IntArray value = (IntArray)this.getResult();
        value.add(add);
    }

    private synchronized void addOrSetHiding(ReadGraphImpl graph, int add, CacheEntry parent) throws DatabaseException {
        assert (this.isPending());
        IntArray value = (IntArray)this.getResult();
        RelationInfo ri = QueryCacheBase.resultRelationInfoQuery(graph, add, parent, null);
        if (ri.isFunctional) {
            try {
                IntSet supers = QueryCache.resultSuperRelations(graph, add, parent, null);
                if (value.data == null) {
                    if (value.sizeOrData != -1 && supers.contains(value.sizeOrData)) {
                        value.sizeOrData = add;
                        return;
                    }
                } else {
                    int i = 0;
                    while (i < value.sizeOrData) {
                        if (supers.contains(value.data[i])) {
                            value.data[i] = add;
                            return;
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable e) {
                this.except(e);
                return;
            }
        }
        value.add(add);
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return EXCEPTED;
        }
        IntArray value = (IntArray)this.getResult();
        if (value.data == null) {
            if (value.sizeOrData != -1) {
                procedure.execute(graph, value.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < value.sizeOrData) {
                procedure.execute(graph, value.data[i]);
                ++i;
            }
        }
        procedure.finished(graph);
        return value;
    }

    @Override
    public void recompute(ReadGraphImpl graph) throws DatabaseException {
        this.compute(graph, new IntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                new Error("Error in recompute.", t).printStackTrace();
            }
        });
    }
}

