/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.graph;

import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.support.ResourceSupport;

public final class InternalStatement implements Statement, Comparable<Statement> {
	
	final ResourceSupport support;
    final int s;
    final int p;
    final int o;
    
    public InternalStatement(ResourceSupport support, final int s, final int p, final int o) {
    	this.support = support;
        this.s = s;
        this.p = p;
        this.o = o;
    }
    
	@Override
	public Resource getSubject() {
		return new ResourceImpl(support, s);
	}

	@Override
	public Resource getPredicate() {
		return new ResourceImpl(support, p);
	}

	@Override
	public Resource getObject() {
		return new ResourceImpl(support, o);
	}

	@Override
	public boolean isAsserted(Resource subject) {
		return ((ResourceImpl)subject).id != s;
	}
    
    @Override
    final public int hashCode() {
        return 41 * ( 31 * s + p) + o;
    }

    final private int id(Resource r) {
    	return ((ResourceImpl)r).id;
    }
    
    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof Statement))
            return false;
        Statement r = (Statement)object;
        return s == id(r.getSubject()) && p == id(r.getPredicate()) && o== id(r.getObject());
    }
    
    @Override
    public int compareTo(Statement other) {
        int result = compare(s,id(other.getSubject()));
        if(result != 0) return result;
        result = compare(p,id(other.getPredicate()));
        if(result != 0) return result;
        return compare(o,id(other.getObject()));
    }

    private int compare(int x, int y) {
        return (x < y) ? -1 : ((x == y) ? 0 : 1);
    }

}

