/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

import org.simantics.db.Resource;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QuerySupport;

public class ArraySet implements Set<Resource> {
    
    final Resource[] set;

    ArraySet(IntSet intSet, QuerySupport support) {
        
        if(intSet.data == null) {
            if(intSet.sizeOrData != IntSet.NO_DATA) {
                set = new Resource[] { support.getResource(intSet.sizeOrData) };
            } else {
                set = Resource.NONE;
            }
        } else {
            set = new Resource[intSet.sizeOrData];
            for(int i=0;i<intSet.sizeOrData;i++) set[i] = support.getResource(intSet.data[i]);
        }
        
    }
    
    @Override
    public boolean add(Resource e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Resource> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        for(int i=0;i<set.length;i++) if(o.equals(set[i])) return true;
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return set.length == 0;
    }

    @Override
    public Iterator<Resource> iterator() {
        
        class ArraySetIterator implements Iterator<Resource> {
            
            int next = 0;

            @Override
            public boolean hasNext() {
                return next < set.length;
            }

            @Override
            public Resource next() {
                return set[next++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
            
        }
        
        return new ArraySetIterator();
        
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return set.length;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

}
