/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

public abstract class ValueType {
    private ValueType() {
    }

    public abstract int getConstantSize();

    public abstract void serialize(ByteBuffer var1, Object var2);

    public abstract void unsafeSerialize(ByteBuffer var1, Object var2);

    public abstract Object deserialize(ByteBuffer var1);

    public boolean supportsNativeArray() {
        return false;
    }

    public void serializeNativeArray(ByteBuffer buffer, Object obj, int length) {
    }

    public Object deserializeNativeArray(ByteBuffer buffer, int length) {
        return null;
    }

    public byte[] serialize(Object obj) {
        int constantSize = this.getConstantSize();
        ByteBuffer buffer = new ByteBuffer(constantSize >= 0 ? constantSize : 0);
        this.serialize(buffer, obj);
        return buffer.content();
    }

    public Object deserialize(byte[] bytes) {
        return this.deserialize(new ByteBuffer(bytes));
    }

    /* synthetic */ ValueType(ValueType valueType) {
        this();
    }

    public static class BooleanType
    extends ValueType {
        public BooleanType() {
            super(null);
        }

        @Override
        public int getConstantSize() {
            return 1;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            buffer.needs(1);
            buffer.putByte((Boolean)obj != false ? (byte)1 : 0);
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
            buffer.putByte((Boolean)obj != false ? (byte)1 : 0);
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            if (buffer.getByte() != 0) {
                return true;
            }
            return false;
        }
    }

    private static final class ByteBuffer {
        public byte[] bytes;
        public int offset;

        public ByteBuffer(int capacity) {
            this.bytes = new byte[capacity];
            this.offset = 0;
        }

        public ByteBuffer(byte[] bytes) {
            this.bytes = bytes;
            this.offset = 0;
        }

        public void needs(int size) {
            if (this.offset + size > this.bytes.length) {
                byte[] newBytes = new byte[this.offset * 2 + size];
                int i = 0;
                while (i < this.bytes.length) {
                    newBytes[i] = this.bytes[i];
                    ++i;
                }
                this.bytes = newBytes;
            }
        }

        public byte[] content() {
            if (this.offset == this.bytes.length) {
                return this.bytes;
            }
            byte[] newBytes = new byte[this.offset];
            int i = 0;
            while (i < this.offset) {
                newBytes[i] = this.bytes[i];
                ++i;
            }
            return newBytes;
        }

        public void putByte(byte v) {
            this.bytes[this.offset] = v;
            ++this.offset;
        }

        public void putShort(short v) {
            this.bytes[this.offset] = (byte)v;
            this.bytes[this.offset + 1] = (byte)(v >>> 8);
            this.offset += 2;
        }

        public void putInt(int v) {
            this.bytes[this.offset] = (byte)v;
            this.bytes[this.offset + 1] = (byte)(v >>> 8);
            this.bytes[this.offset + 2] = (byte)(v >>> 16);
            this.bytes[this.offset + 3] = (byte)(v >>> 24);
            this.offset += 4;
        }

        public void putLong(long v) {
            this.bytes[this.offset] = (byte)v;
            this.bytes[this.offset + 1] = (byte)(v >>> 8);
            this.bytes[this.offset + 2] = (byte)(v >>> 16);
            this.bytes[this.offset + 3] = (byte)(v >>> 24);
            this.bytes[this.offset + 4] = (byte)(v >>> 32);
            this.bytes[this.offset + 5] = (byte)(v >>> 40);
            this.bytes[this.offset + 6] = (byte)(v >>> 48);
            this.bytes[this.offset + 7] = (byte)(v >>> 56);
            this.offset += 8;
        }

        public void putFloat(float _v) {
            int v = Float.floatToIntBits(_v);
            this.bytes[this.offset] = (byte)v;
            this.bytes[this.offset + 1] = (byte)(v >>> 8);
            this.bytes[this.offset + 2] = (byte)(v >>> 16);
            this.bytes[this.offset + 3] = (byte)(v >>> 24);
            this.offset += 4;
        }

        public void putDouble(double _v) {
            long v = Double.doubleToLongBits(_v);
            this.bytes[this.offset] = (byte)v;
            this.bytes[this.offset + 1] = (byte)(v >>> 8);
            this.bytes[this.offset + 2] = (byte)(v >>> 16);
            this.bytes[this.offset + 3] = (byte)(v >>> 24);
            this.bytes[this.offset + 4] = (byte)(v >>> 32);
            this.bytes[this.offset + 5] = (byte)(v >>> 40);
            this.bytes[this.offset + 6] = (byte)(v >>> 48);
            this.bytes[this.offset + 7] = (byte)(v >>> 56);
            this.offset += 8;
        }

        public void putString(String str) {
            char c;
            int length = 4;
            int i = 0;
            while (i < str.length()) {
                c = str.charAt(i);
                length = c < '\u0080' ? ++length : (c < '\u0800' ? (length += 2) : (length += 3));
                ++i;
            }
            this.needs(length);
            this.putInt(str.length());
            i = 0;
            while (i < str.length()) {
                c = str.charAt(i);
                if (c < '\u0080') {
                    this.bytes[this.offset] = (byte)c;
                    ++this.offset;
                } else if (c < '\u0800') {
                    this.bytes[this.offset] = (byte)(192 + (c >>> 6));
                    this.bytes[this.offset + 1] = (byte)(128 + (c & 0x3F));
                    this.offset += 2;
                } else {
                    this.bytes[this.offset] = (byte)(224 + (c >>> 12));
                    this.bytes[this.offset + 1] = (byte)(128 + (c >>> 6 & 0x3F));
                    this.bytes[this.offset + 2] = (byte)(128 + (c & 0x3F));
                    this.offset += 3;
                }
                ++i;
            }
        }

        public byte getByte() {
            ++this.offset;
            return this.bytes[this.offset - 1];
        }

        public short getShort() {
            int v = this.bytes[this.offset] & 0xFF;
            this.offset += 2;
            return (short)(v += (this.bytes[this.offset + 1] & 0xFF) << 8);
        }

        public int getInt() {
            int v = this.bytes[this.offset] & 0xFF;
            v += (this.bytes[this.offset + 1] & 0xFF) << 8;
            v += (this.bytes[this.offset + 2] & 0xFF) << 16;
            this.offset += 4;
            return v += (this.bytes[this.offset + 3] & 0xFF) << 24;
        }

        public long getLong() {
            long v = (long)this.bytes[this.offset] & 0xFFL;
            v += ((long)this.bytes[this.offset + 1] & 0xFFL) << 8;
            v += ((long)this.bytes[this.offset + 2] & 0xFFL) << 16;
            v += ((long)this.bytes[this.offset + 3] & 0xFFL) << 24;
            v += ((long)this.bytes[this.offset + 4] & 0xFFL) << 32;
            v += ((long)this.bytes[this.offset + 5] & 0xFFL) << 40;
            v += ((long)this.bytes[this.offset + 6] & 0xFFL) << 48;
            this.offset += 8;
            return v += ((long)this.bytes[this.offset + 7] & 0xFFL) << 56;
        }

        public float getFloat() {
            int v = this.bytes[this.offset] & 0xFF;
            v += (this.bytes[this.offset + 1] & 0xFF) << 8;
            v += (this.bytes[this.offset + 2] & 0xFF) << 16;
            this.offset += 4;
            return Float.intBitsToFloat(v += (this.bytes[this.offset + 3] & 0xFF) << 24);
        }

        public double getDouble() {
            long v = (long)this.bytes[this.offset] & 0xFFL;
            v += ((long)this.bytes[this.offset + 1] & 0xFFL) << 8;
            v += ((long)this.bytes[this.offset + 2] & 0xFFL) << 16;
            v += ((long)this.bytes[this.offset + 3] & 0xFFL) << 24;
            v += ((long)this.bytes[this.offset + 4] & 0xFFL) << 32;
            v += ((long)this.bytes[this.offset + 5] & 0xFFL) << 40;
            v += ((long)this.bytes[this.offset + 6] & 0xFFL) << 48;
            this.offset += 8;
            return Double.longBitsToDouble(v += ((long)this.bytes[this.offset + 7] & 0xFFL) << 56);
        }

        public String getString() {
            int length = this.getInt();
            char[] chars = new char[length];
            int i = 0;
            while (i < length) {
                int c;
                int b0 = this.bytes[this.offset];
                if (b0 >= 0) {
                    c = b0;
                    ++this.offset;
                } else if (b0 < -32) {
                    c = ((b0 & 0x1F) << 6) + (this.bytes[this.offset + 1] & 0x3F);
                    this.offset += 2;
                } else if (b0 < -16) {
                    c = ((b0 & 0xF) << 12) + ((this.bytes[this.offset + 1] & 0x3F) << 6) + (this.bytes[this.offset + 2] & 0x3F);
                    this.offset += 3;
                } else {
                    c = 0;
                }
                chars[i] = (char)c;
                ++i;
            }
            return new String(chars);
        }
    }

    public static class ByteType
    extends ValueType {
        public ByteType() {
            super(null);
        }

        @Override
        public int getConstantSize() {
            return 1;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            buffer.needs(1);
            buffer.putByte((Byte)obj);
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
            buffer.putByte((Byte)obj);
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            return buffer.getByte();
        }
    }

    public static class Construction {
        int constructor;
        Object value;
    }

    public static class DoubleType
    extends ValueType {
        public DoubleType() {
            super(null);
        }

        @Override
        public int getConstantSize() {
            return 8;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            buffer.needs(8);
            buffer.putDouble((Double)obj);
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
            buffer.putDouble((Double)obj);
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            return buffer.getDouble();
        }

        @Override
        public boolean supportsNativeArray() {
            return true;
        }

        @Override
        public void serializeNativeArray(ByteBuffer buffer, Object obj, int length) {
            double[] array = (double[])obj;
            if (length < 0) {
                buffer.putInt(array.length);
            }
            double[] dArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                buffer.putDouble(d);
                ++n2;
            }
        }

        @Override
        public Object deserializeNativeArray(ByteBuffer buffer, int length) {
            double[] ret = new double[length];
            int i = 0;
            while (i < length) {
                ret[i] = buffer.getDouble();
                ++i;
            }
            return ret;
        }
    }

    public static class FixedLengthArrayType
    extends ValueType {
        public final ValueType baseType;
        public final int dimension;
        private int constantSize;
        private boolean supportsNativeArray;

        public FixedLengthArrayType(ValueType baseType, int dimension) {
            super(null);
            this.baseType = baseType;
            this.dimension = dimension;
            this.constantSize = baseType.getConstantSize();
            if (this.constantSize >= 0) {
                this.constantSize *= dimension;
                this.supportsNativeArray = baseType.supportsNativeArray();
            }
        }

        @Override
        public int getConstantSize() {
            return this.constantSize;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            if (this.constantSize >= 0) {
                buffer.needs(this.constantSize);
                this.unsafeSerialize(buffer, obj);
            } else {
                Object[] subobjects;
                Object[] objectArray = subobjects = (Object[])obj;
                int n = subobjects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object subobj = objectArray[n2];
                    this.baseType.serialize(buffer, subobj);
                    ++n2;
                }
            }
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
            if (this.supportsNativeArray) {
                this.baseType.serializeNativeArray(buffer, obj, this.dimension);
            } else {
                Object[] subobjects;
                Object[] objectArray = subobjects = (Object[])obj;
                int n = subobjects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object subobj = objectArray[n2];
                    this.baseType.unsafeSerialize(buffer, subobj);
                    ++n2;
                }
            }
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            if (this.supportsNativeArray) {
                return this.baseType.deserializeNativeArray(buffer, this.dimension);
            }
            Object[] ret = new Object[this.dimension];
            int i = 0;
            while (i < this.dimension) {
                ret[i] = this.baseType.deserialize(buffer);
                ++i;
            }
            return ret;
        }
    }

    public static class FloatType
    extends ValueType {
        public FloatType() {
            super(null);
        }

        @Override
        public int getConstantSize() {
            return 4;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            buffer.needs(4);
            buffer.putFloat(((Float)obj).floatValue());
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
            buffer.putFloat(((Float)obj).floatValue());
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            return Float.valueOf(buffer.getFloat());
        }
    }

    public static class IntegerType
    extends ValueType {
        public IntegerType() {
            super(null);
        }

        @Override
        public int getConstantSize() {
            return 4;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            buffer.needs(4);
            buffer.putInt((Integer)obj);
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
            buffer.putInt((Integer)obj);
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            return buffer.getInt();
        }
    }

    public static class LongType
    extends ValueType {
        public LongType() {
            super(null);
        }

        @Override
        public int getConstantSize() {
            return 8;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            buffer.needs(8);
            buffer.putLong((Long)obj);
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
            buffer.putLong((Long)obj);
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            return buffer.getLong();
        }
    }

    public static class ProductType
    extends ValueType {
        public final ValueType[] baseTypes;
        private int constantSize;

        public ProductType(ValueType[] baseTypes) {
            super(null);
            this.baseTypes = baseTypes;
            this.constantSize = 0;
            ValueType[] valueTypeArray = baseTypes;
            int n = baseTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ValueType b = valueTypeArray[n2];
                int temp = b.getConstantSize();
                if (temp == -1) {
                    this.constantSize = -1;
                    break;
                }
                this.constantSize += temp;
                ++n2;
            }
        }

        @Override
        public int getConstantSize() {
            return this.constantSize;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            if (this.constantSize >= 0) {
                buffer.needs(this.constantSize);
                this.unsafeSerialize(buffer, obj);
            } else {
                Object[] subobjects = (Object[])obj;
                int i = 0;
                while (i < this.baseTypes.length) {
                    this.baseTypes[i].serialize(buffer, subobjects[i]);
                    ++i;
                }
            }
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
            Object[] subobjects = (Object[])obj;
            int i = 0;
            while (i < this.baseTypes.length) {
                this.baseTypes[i].unsafeSerialize(buffer, subobjects[i]);
                ++i;
            }
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            Object[] ret = new Object[this.baseTypes.length];
            int i = 0;
            while (i < this.baseTypes.length) {
                ret[i] = this.baseTypes[i].deserialize(buffer);
                ++i;
            }
            return ret;
        }
    }

    public static class StringType
    extends ValueType {
        public StringType() {
            super(null);
        }

        @Override
        public int getConstantSize() {
            return -1;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            buffer.putString((String)obj);
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            return buffer.getString();
        }
    }

    public static class SumType
    extends ValueType {
        public final ValueType[] baseTypes;
        private int constantSize;

        public SumType(ValueType[] baseTypes) {
            super(null);
            this.baseTypes = baseTypes;
            this.constantSize = -2;
            ValueType[] valueTypeArray = baseTypes;
            int n = baseTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ValueType b = valueTypeArray[n2];
                int temp = b.getConstantSize();
                if (temp != this.constantSize) {
                    if (this.constantSize == -2 && temp >= 0) {
                        this.constantSize = temp;
                    } else {
                        this.constantSize = -1;
                        break;
                    }
                }
                ++n2;
            }
            if (this.constantSize >= 0) {
                this.constantSize += 4;
            }
        }

        @Override
        public int getConstantSize() {
            return this.constantSize;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            if (this.constantSize >= 0) {
                buffer.needs(this.constantSize);
                this.unsafeSerialize(buffer, obj);
            } else {
                Construction construction = (Construction)obj;
                buffer.needs(4);
                buffer.putInt(construction.constructor);
                this.baseTypes[construction.constructor].serialize(buffer, construction.value);
            }
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
            Construction construction = (Construction)obj;
            buffer.putInt(construction.constructor);
            this.baseTypes[construction.constructor].unsafeSerialize(buffer, construction.value);
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            Construction ret = new Construction();
            ret.constructor = buffer.getInt();
            ret.value = this.baseTypes[ret.constructor].deserialize(buffer);
            return ret;
        }
    }

    public static class VariableLengthArrayType
    extends ValueType {
        public final ValueType baseType;
        private int baseTypeConstantSize;
        private boolean supportsNativeArray;

        public VariableLengthArrayType(ValueType baseType) {
            super(null);
            this.baseType = baseType;
            this.baseTypeConstantSize = baseType.getConstantSize();
            this.supportsNativeArray = baseType.supportsNativeArray();
        }

        @Override
        public int getConstantSize() {
            return -1;
        }

        @Override
        public void serialize(ByteBuffer buffer, Object obj) {
            block4: {
                block2: {
                    block3: {
                        if (this.baseTypeConstantSize < 0) break block2;
                        if (!(obj instanceof Object[])) break block3;
                        Object[] subobjects = (Object[])obj;
                        buffer.needs(4 + subobjects.length * this.baseTypeConstantSize);
                        buffer.putInt(subobjects.length);
                        Object[] objectArray = subobjects;
                        int n = subobjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object subobj = objectArray[n2];
                            this.baseType.unsafeSerialize(buffer, subobj);
                            ++n2;
                        }
                        break block4;
                    }
                    if (!this.supportsNativeArray) break block4;
                    this.baseType.serializeNativeArray(buffer, obj, -1);
                    break block4;
                }
                Object[] subobjects = (Object[])obj;
                buffer.needs(4);
                buffer.putInt(subobjects.length);
                Object[] objectArray = subobjects;
                int n = subobjects.length;
                int n3 = 0;
                while (n3 < n) {
                    Object subobj = objectArray[n3];
                    this.baseType.serialize(buffer, subobj);
                    ++n3;
                }
            }
        }

        @Override
        public void unsafeSerialize(ByteBuffer buffer, Object obj) {
        }

        @Override
        public Object deserialize(ByteBuffer buffer) {
            int length = buffer.getInt();
            if (this.supportsNativeArray) {
                return this.baseType.deserializeNativeArray(buffer, length);
            }
            Object[] ret = new Object[length];
            int i = 0;
            while (i < length) {
                ret[i] = this.baseType.deserialize(buffer);
                ++i;
            }
            return ret;
        }
    }
}

