/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class Literals {
    private static final Pattern comma = Pattern.compile(",");
    private static int precision = 8;

    public static int getPrecision() {
        return precision;
    }

    public static void setPrecision(int precision) {
        Literals.precision = precision;
    }

    private static String formattedDouble(double a) {
        try {
            BigDecimal dec = new BigDecimal(String.valueOf(a), new MathContext(precision, RoundingMode.HALF_UP));
            dec = dec.stripTrailingZeros();
            if (dec.scale() < 1) {
                dec = dec.setScale(1);
            }
            return dec.toString();
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid Value";
        }
    }

    public static String toString(double[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(Literals.formattedDouble(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String literalToString(Object literal) throws IllegalArgumentException {
        Class<?> literalClass = literal.getClass();
        if (literalClass == String.class) {
            return (String)literal;
        }
        if (literalClass == Double.class) {
            return literal.toString();
        }
        if (literalClass == Float.class) {
            return literal.toString();
        }
        if (literalClass == Long.class) {
            return literal.toString();
        }
        if (literalClass == Integer.class) {
            return literal.toString();
        }
        if (literalClass == Byte.class) {
            return literal.toString();
        }
        if (literalClass == Boolean.class) {
            return literal.toString();
        }
        if (literalClass == String[].class) {
            return Literals.literalToString((String[])literal);
        }
        if (literalClass == double[].class) {
            return Literals.literalToString((double[])literal);
        }
        if (literalClass == float[].class) {
            return Literals.literalToString((float[])literal);
        }
        if (literalClass == long[].class) {
            return Literals.literalToString((long[])literal);
        }
        if (literalClass == int[].class) {
            return Literals.literalToString((int[])literal);
        }
        if (literalClass == byte[].class) {
            return Literals.literalToString((byte[])literal);
        }
        if (literalClass == boolean[].class) {
            return Literals.literalToString((boolean[])literal);
        }
        throw new IllegalArgumentException(String.format("Literal object type not recognized: %s", literal.getClass().getName()));
    }

    public static String shortString(Object original) {
        if (original.toString().length() > 100) {
            return String.valueOf(original.toString().substring(0, 99)) + "...";
        }
        return original.toString();
    }

    public static String literalToString(boolean[] l) throws IllegalArgumentException {
        return l.length == 1 ? String.valueOf(l[0]) : Arrays.toString(l);
    }

    public static String literalToString(byte[] l) throws IllegalArgumentException {
        return l.length == 1 ? String.valueOf(l[0]) : Arrays.toString(l);
    }

    public static String literalToString(int[] l) throws IllegalArgumentException {
        return l.length == 1 ? String.valueOf(l[0]) : Arrays.toString(l);
    }

    public static String literalToString(long[] l) throws IllegalArgumentException {
        return l.length == 1 ? String.valueOf(l[0]) : Arrays.toString(l);
    }

    public static String literalToString(float[] l) throws IllegalArgumentException {
        return l.length == 1 ? String.valueOf(l[0]) : Arrays.toString(l);
    }

    public static String literalToString(double[] l) throws IllegalArgumentException {
        return l.length == 1 ? String.valueOf(l[0]) : Arrays.toString(l);
    }

    public static String literalToString(String[] l) throws IllegalArgumentException {
        return l.length == 1 ? String.valueOf(l[0]) : Arrays.toString(l);
    }

    public static boolean[] parseBooleanLiteral(String literal) {
        literal = Literals.trimLiteralString(literal);
        try {
            String[] parts = comma.split(literal);
            boolean[] result = new boolean[parts.length];
            int i = 0;
            while (i < parts.length) {
                result[i] = Boolean.parseBoolean(parts[i]);
                ++i;
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid boolean value: " + literal, e);
        }
    }

    public static double[] parseDoubleLiteral(String literal) {
        literal = Literals.trimLiteralString(literal);
        try {
            String[] parts = comma.split(literal);
            double[] result = new double[parts.length];
            int i = 0;
            while (i < parts.length) {
                result[i] = Double.parseDouble(parts[i]);
                ++i;
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid double value: " + literal, e);
        }
    }

    public static int[] parseIntegerLiteral(String literal) {
        literal = Literals.trimLiteralString(literal);
        try {
            String[] parts = comma.split(literal);
            int[] result = new int[parts.length];
            int i = 0;
            while (i < parts.length) {
                result[i] = Integer.parseInt(parts[i]);
                ++i;
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid integer value: " + literal, e);
        }
    }

    public static byte[] parseByteLiteral(String literal) {
        literal = Literals.trimLiteralString(literal);
        try {
            String[] parts = comma.split(literal);
            byte[] result = new byte[parts.length];
            int i = 0;
            while (i < parts.length) {
                result[i] = Byte.parseByte(parts[i]);
                ++i;
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid byte value: " + literal, e);
        }
    }

    public static long[] parseLongLiteral(String literal) {
        literal = Literals.trimLiteralString(literal);
        try {
            String[] parts = comma.split(literal);
            long[] result = new long[parts.length];
            int i = 0;
            while (i < parts.length) {
                result[i] = Long.parseLong(parts[i]);
                ++i;
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid long value: " + literal, e);
        }
    }

    public static float[] parseFloatLiteral(String literal) {
        literal = Literals.trimLiteralString(literal);
        try {
            String[] parts = comma.split(literal);
            float[] result = new float[parts.length];
            int i = 0;
            while (i < parts.length) {
                result[i] = Float.parseFloat(parts[i]);
                ++i;
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid float value: " + literal, e);
        }
    }

    private static String[] parseStringLiteral(String literal) {
        return new String[]{literal};
    }

    private static String trimLiteralString(String literal) {
        if ((literal = literal.trim()).startsWith("[")) {
            literal = literal.substring(1);
        }
        if (literal.endsWith("]")) {
            literal = literal.substring(0, literal.length() - 1);
        }
        return literal;
    }
}

