/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphList
extends AbstractSequentialList<Resource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphList.class);
    private final ReadGraph graph;
    private final Layer0 L0;
    private final Resource root;
    private final Resource elementRelation;

    public GraphList(ReadGraph graph, Resource root, Resource elementRelation) {
        this.graph = graph;
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.root = root;
        this.elementRelation = elementRelation;
    }

    public GraphList(ReadGraph graph, Resource root) throws DatabaseException {
        this.graph = graph;
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.root = root;
        this.elementRelation = graph.getSingleObject(root, this.L0.List_ElementPredicate);
    }

    @Override
    public ListIterator<Resource> listIterator(int index) {
        GraphListIterator it = new GraphListIterator(this.root, this.browseNext(this.root), 0);
        while (index > 0) {
            it.goNext();
            --index;
        }
        return it;
    }

    private Resource browseNext(Resource cur) {
        try {
            return this.graph.getSingleObject(cur, this.L0.List_Next);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    private Resource browsePrev(Resource cur) {
        try {
            return this.graph.getSingleObject(cur, this.L0.List_Previous);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    private Resource browseElement(Resource cur) {
        try {
            LOGGER.info("browseElement " + cur);
            return this.graph.getSingleObject(cur, this.elementRelation);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    private void addBetween(Resource prev, Resource next, Resource element) {
        WriteGraph graph;
        try {
            graph = (WriteGraph)this.graph;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Cannot add element in read transaction.");
        }
        try {
            graph.deny(prev, this.L0.List_Next, this.L0.List_Previous, next);
            Resource newEntry = graph.newResource();
            graph.claim(newEntry, this.L0.InstanceOf, this.L0.List_Entry);
            graph.claim(newEntry, this.elementRelation, element);
            graph.claim(newEntry, this.L0.IsOwnedBy, this.L0.IsComposedOf, this.root);
            graph.claim(prev, this.L0.List_Next, this.L0.List_Previous, newEntry);
            graph.claim(newEntry, this.L0.List_Next, this.L0.List_Previous, next);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    private void doSet(Resource target, Resource resource) {
        WriteGraph graph;
        try {
            graph = (WriteGraph)this.graph;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Cannot set element in read transaction.");
        }
        try {
            graph.deny(target, this.elementRelation);
            graph.claim(target, this.elementRelation, resource);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    private void doRemove(Resource prev, Resource target, Resource next) {
        WriteGraph graph;
        try {
            graph = (WriteGraph)this.graph;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Cannot remove element in read transaction.");
        }
        try {
            graph.deny(target);
            graph.claim(prev, this.L0.List_Next, this.L0.List_Previous, next);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        int count = 0;
        Resource cur = this.browseNext(this.root);
        while (cur != this.root) {
            ++count;
            cur = this.browseNext(cur);
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.graph.hasStatement(this.root, this.L0.List_Next, this.root);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    class GraphListIterator
    implements ListIterator<Resource> {
        private Resource prev;
        private Resource next;
        private int id;
        private int lastOp;

        public GraphListIterator(Resource prev, Resource next, int id) {
            LOGGER.info("GraphListIterator root=" + GraphList.this.root + " prev=" + prev + " next=" + next);
            this.prev = prev;
            this.next = next;
            this.id = id;
            this.lastOp = 0;
        }

        @Override
        public boolean hasNext() {
            LOGGER.info("hasNext root=" + GraphList.this.root + " prev=" + this.prev + " next=" + this.next);
            return this.next != GraphList.this.root;
        }

        void goNext() {
            LOGGER.info("goNext prev=" + this.prev + " next=" + this.next);
            if (this.next == GraphList.this.root) {
                this.lastOp = 0;
                throw new NoSuchElementException();
            }
            this.prev = this.next;
            this.next = GraphList.this.browseNext(this.next);
            ++this.id;
            this.lastOp = 1;
            LOGGER.info("       prev=" + this.prev + " next=" + this.next);
        }

        void goPrev() {
            if (this.prev == GraphList.this.root) {
                this.lastOp = 0;
                throw new NoSuchElementException();
            }
            this.next = this.prev;
            this.prev = GraphList.this.browsePrev(this.prev);
            --this.id;
            this.lastOp = -1;
        }

        @Override
        public Resource next() {
            this.goNext();
            return GraphList.this.browseElement(this.prev);
        }

        @Override
        public boolean hasPrevious() {
            return this.prev != GraphList.this.root;
        }

        @Override
        public Resource previous() {
            this.goPrev();
            return GraphList.this.browseElement(this.next);
        }

        @Override
        public int nextIndex() {
            return this.id;
        }

        @Override
        public int previousIndex() {
            return this.id - 1;
        }

        @Override
        public void remove() {
            Resource target;
            if (this.lastOp == 1) {
                target = this.prev;
                this.prev = GraphList.this.browsePrev(this.prev);
            } else if (this.lastOp == -1) {
                target = this.next;
                this.next = GraphList.this.browseNext(this.next);
            } else {
                throw new UnsupportedOperationException("Cannot remove element, when no previous next/prev call.");
            }
            GraphList.this.doRemove(this.prev, target, this.next);
            this.lastOp = 0;
        }

        @Override
        public void set(Resource e) {
            Resource target;
            if (this.lastOp == 1) {
                target = this.prev;
            } else if (this.lastOp == -1) {
                target = this.next;
            } else {
                throw new UnsupportedOperationException("Cannot remove element, when no previous next/prev call.");
            }
            GraphList.this.doSet(target, e);
        }

        @Override
        public void add(Resource e) {
            GraphList.this.addBetween(this.prev, this.next, e);
            this.lastOp = 0;
        }
    }
}

