/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.service;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.service.ServiceActivityMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceActivityMonitorImpl
implements ServiceActivityMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceActivityMonitorImpl.class);
    public static final long REPORTING_PERIOD = 5L;
    Semaphore sem = new Semaphore(1);
    AtomicInteger ref = new AtomicInteger();
    TObjectIntMap<Object> ids = new TObjectIntHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActivity(Object id) {
        if (this.ref.getAndIncrement() == 0) {
            this.sem.acquireUninterruptibly(1);
        }
        TObjectIntMap<Object> tObjectIntMap = this.ids;
        synchronized (tObjectIntMap) {
            this.ids.adjustOrPutValue(id, 1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterActivity(Object id) {
        TObjectIntMap<Object> tObjectIntMap = this.ids;
        synchronized (tObjectIntMap) {
            int refs = this.ids.get(id);
            if (refs == 1) {
                this.ids.remove(id);
            } else {
                this.ids.put(id, refs - 1);
            }
        }
        if (this.ref.decrementAndGet() == 0) {
            this.sem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() throws InterruptedException {
        while (!this.waitForCompletion(5L, TimeUnit.SECONDS)) {
            TObjectIntMap<Object> tObjectIntMap = this.ids;
            synchronized (tObjectIntMap) {
                LOGGER.info("waitForCompletion: " + this.ids);
            }
        }
        return;
    }

    public boolean waitForCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.sem.tryAcquire(timeout, unit)) {
            this.sem.release();
            return true;
        }
        return false;
    }
}

