/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.processor;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.processor.ProcessorBase;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.DelayedWrite;

public final class MergingDelayedWriteProcessor
extends ProcessorBase {
    final long transactionKeepalivePeriod;
    final ConcurrentLinkedQueue<DelayedWrite> queue = new ConcurrentLinkedQueue();
    private final AsyncRequestProcessor processor;
    boolean hasAlreadyRequest = false;

    public MergingDelayedWriteProcessor(AsyncRequestProcessor processor, long transactionKeepalivePeriod) {
        this.processor = processor;
        this.transactionKeepalivePeriod = transactionKeepalivePeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncRequest(DelayedWrite request) {
        this.queue.add(request);
        MergingDelayedWriteProcessor mergingDelayedWriteProcessor = this;
        synchronized (mergingDelayedWriteProcessor) {
            if (!this.hasAlreadyRequest) {
                this.processor.asyncRequest((DelayedWrite)new MergedWrite());
                this.hasAlreadyRequest = true;
            } else {
                this.notify();
            }
        }
    }

    public String toString() {
        return "MergingDelayedWriteProcessor@" + System.identityHashCode(this) + " (based on " + this.processor + ")";
    }

    class MergedWrite
    extends DelayedWriteRequest {
        MergedWrite() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(WriteGraph graph) throws DatabaseException {
            while (true) {
                DelayedWrite next;
                if ((next = MergingDelayedWriteProcessor.this.queue.poll()) == null) {
                    MergingDelayedWriteProcessor mergingDelayedWriteProcessor = MergingDelayedWriteProcessor.this;
                    synchronized (mergingDelayedWriteProcessor) {
                        if (MergingDelayedWriteProcessor.this.transactionKeepalivePeriod > 0L) {
                            try {
                                MergingDelayedWriteProcessor.this.wait(MergingDelayedWriteProcessor.this.transactionKeepalivePeriod);
                            }
                            catch (InterruptedException e) {
                                Logger.defaultLogError(e);
                            }
                            next = MergingDelayedWriteProcessor.this.queue.poll();
                        }
                        if (next == null) {
                            MergingDelayedWriteProcessor.this.hasAlreadyRequest = false;
                            return;
                        }
                    }
                }
                try {
                    next.perform(graph);
                    continue;
                }
                catch (Throwable t) {
                    Logger.defaultLogError(t);
                    continue;
                }
                break;
            }
        }
    }
}

