/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeMap;
import org.simantics.db.Session;
import org.simantics.db.common.ACommentMetadata;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.Serializers;

public class UndoMetadata
extends ACommentMetadata {
    private boolean redo;
    private long begin;
    private long end;

    public UndoMetadata(byte[] comments, boolean redo, long begin, long end) {
        super(comments);
        this.redo = redo;
        this.begin = begin;
        this.end = end;
    }

    public UndoMetadata(TreeMap<String, byte[]> metadata) {
        super((byte[])null);
        if (metadata != null) {
            byte[] data = metadata.get(UndoMetadata.class.getName());
            this.initialize(data);
        }
    }

    public UndoMetadata(byte[] data) {
        super((byte[])null);
        this.initialize(data);
    }

    private void initialize(byte[] data) {
        if (data != null) {
            try {
                UndoMetadata um = UndoMetadata.deserialise(null, data);
                this.comments = um.comments;
                this.redo = um.redo;
                this.begin = um.begin;
                this.end = um.end;
            }
            catch (Exception e) {
                Logger.defaultLogError(e);
            }
        }
    }

    @Override
    public byte[] serialise(Session session) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            byte[] bytes = Serializers.serializeStrings(this.comments.toArray(new String[this.comments.size()]));
            oos.writeInt(bytes.length);
            oos.write(bytes);
            oos.writeBoolean(this.redo);
            oos.writeLong(this.begin);
            oos.writeLong(this.end);
            oos.close();
            return os.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.defaultLogError(e.toString());
            return new byte[0];
        }
    }

    public static UndoMetadata deserialise(Session session, byte[] input) {
        try {
            if (input == null) {
                return new UndoMetadata(null, false, 0L, 0L);
            }
            ByteArrayInputStream is = new ByteArrayInputStream(input);
            ObjectInputStream ois = new ObjectInputStream(is);
            int len = ois.readInt();
            if (len < 0) {
                throw new Error("Deserialisation error. Illegal string length=" + len);
            }
            byte[] bytes = new byte[len];
            ois.readFully(bytes);
            boolean redo = ois.readBoolean();
            long begin = ois.readLong();
            long end = ois.readLong();
            ois.close();
            return new UndoMetadata(bytes, redo, begin, end);
        }
        catch (Throwable e) {
            Logger.defaultLogError(e);
            return new UndoMetadata(null, false, 0L, 0L);
        }
    }

    public boolean isRedo() {
        return this.redo;
    }

    public long getBeginCSId() {
        return this.begin;
    }

    public long getEndCSId() {
        return this.end;
    }

    public void setTypeAndRange(UndoMetadata um) {
        this.redo = !um.redo;
        this.begin = um.begin;
        this.end = um.end;
    }

    public void setTypeAndRange(boolean redo, long begin, long end) {
        this.redo = redo;
        this.begin = begin;
        this.end = end;
    }

    public String getType() {
        return this.redo ? "Redo" : "Undo";
    }

    public String getRange() {
        return "[" + this.begin + "," + this.end + "]";
    }

    public String getHeader() {
        return String.valueOf(this.getType()) + this.getRange();
    }

    public boolean isEmpty() {
        return this.begin == 0L && this.end == 0L;
    }
}

