/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.db.Operation;
import org.simantics.db.UndoContext;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoHistoryException;
import org.simantics.db.service.ExternalOperation;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.utils.threads.ThreadUtils;

public class UndoContextEx
implements UndoContext {
    private static HashMap<String, Weak> contexts = new HashMap();
    protected static final boolean DEBUG = false;
    protected final boolean DISABLED = false;
    private final Operations operations = new Operations();
    private final Deque<Operation> redos = new ArrayDeque<Operation>();
    private final ArrayList<ExternalOperation> pendingExternals = new ArrayList();
    private final String name;
    private boolean undoRedoOn = false;
    private final String id;
    private boolean commitOkDisabled = false;

    public UndoContextEx() {
        this.name = this.id = this.getUniqueId(this.toString());
        this.init();
    }

    public UndoContextEx(String id) {
        this.id = this.getUniqueId(id);
        this.name = id;
        this.init();
    }

    public UndoContextEx(String id, String name) {
        this.id = this.getUniqueId(id);
        this.name = name;
        this.init();
    }

    private String getUniqueId(String id) {
        String uniqueId = id;
        int i = 0;
        while (contexts.containsKey(uniqueId)) {
            uniqueId = String.valueOf(uniqueId) + "_" + ++i;
        }
        return uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        UndoContextEx undoContextEx = this;
        synchronized (undoContextEx) {
            Weak old = contexts.get(this.id);
            assert (old == null);
            contexts.put(this.id, new Weak(this));
        }
    }

    public static synchronized UndoContext getUndoContext(String id) {
        Weak w = contexts.get(id);
        UndoContext c = w == null ? null : w.get();
        return c;
    }

    public static synchronized Collection<UndoContext> getUndoContexts() {
        ArrayList<UndoContext> ucs = new ArrayList<UndoContext>();
        ArrayList<Weak> weaks = new ArrayList<Weak>();
        ArrayList<String> stale = new ArrayList<String>();
        for (Map.Entry<String, Weak> e : contexts.entrySet()) {
            UndoContext c = e.getValue().get();
            if (c != null) {
                ucs.add(c);
                weaks.add(new Weak(c));
                continue;
            }
            stale.add(e.getKey());
        }
        for (String id : stale) {
            contexts.remove(id);
        }
        return ucs;
    }

    public String toString() {
        return String.valueOf(this.name) + "@" + Integer.toHexString(this.hashCode());
    }

    public void commitOk(Operation op) throws DatabaseException {
        if (this.commitOkDisabled) {
            return;
        }
        if (this.undoRedoOn) {
            this.undoRedoOn = false;
            this.redos.clear();
        }
        if (op.getId() < 1L || op.getId() == op.getCSId()) {
            Operation last = this.getLast();
            if (last != null && last.getCSId() == op.getCSId()) {
                Logger.defaultLogError("Duplicate operation for new operation id=" + op.getId() + ".");
                return;
            }
        } else {
            Operation last = this.operations.getCombined(op.getId());
            if (last == null) {
                Logger.defaultLogError("Missing operation for combined operation id=" + op.getId() + " cs=" + op.getCSId() + ".");
            }
        }
        this.operations.addLast(op);
        this.pendingExternals.clear();
    }

    public void externalCommit(Operation op) {
        this.operations.addLast(op);
        this.pendingExternals.clear();
    }

    public void cancelCommit() {
        this.pendingExternals.clear();
    }

    public Operation getLast() throws DatabaseException {
        return this.operations.getLast();
    }

    protected Operation getLastRedo() throws DatabaseException {
        if (this.redos.size() < 1) {
            return null;
        }
        Operation op = this.redos.getLast();
        return op;
    }

    public Collection<Operation> getAll() throws DatabaseException {
        return this.operations.getAll();
    }

    public Collection<Operation> getRedoList() throws DatabaseException {
        return this.redos;
    }

    public List<Operation> undo(UndoRedoSupport support, int count) throws DatabaseException {
        ArrayList<Operation> ops = new ArrayList<Operation>(count);
        int i = 0;
        while (i < count) {
            Operation op = this.operations.removeLast();
            if (op == null) break;
            for (Operation o : op.getOperations()) {
                ops.add(o);
            }
            ++i;
        }
        if (ops.size() < 1) {
            throw new NoHistoryException("Illegal call, undo list is empty.");
        }
        this.commitOkDisabled = true;
        Operation redo = null;
        try {
            redo = support.undo(ops);
        }
        finally {
            this.commitOkDisabled = false;
        }
        if (redo == null) {
            return Collections.emptyList();
        }
        this.redos.add(redo);
        this.undoRedoOn = true;
        return ops;
    }

    public List<Operation> redo(UndoRedoSupport support, int count) throws DatabaseException {
        ArrayList<Operation> ops = new ArrayList<Operation>(count);
        int i = 0;
        while (i < count) {
            Operation op = this.removeLastRedo();
            if (op == null) break;
            for (Operation o : op.getOperations()) {
                ops.add(o);
            }
            ++i;
        }
        if (ops.size() < 1) {
            throw new NoHistoryException("Illegal call, redo list is empty.");
        }
        Operation undo = null;
        try {
            this.commitOkDisabled = true;
            undo = support.undo(ops);
        }
        finally {
            this.commitOkDisabled = false;
        }
        if (undo == null) {
            return Collections.emptyList();
        }
        this.operations.addLast(undo);
        this.undoRedoOn = true;
        return ops;
    }

    public void clear() {
        this.operations.clear();
        this.redos.clear();
        this.pendingExternals.clear();
    }

    Operation removeLastRedo() {
        if (this.redos.size() < 1) {
            return null;
        }
        Operation op = this.redos.removeLast();
        return op;
    }

    void undoPair(Operation undo, Operation redo) {
        this.operations.remove(undo.getId());
        this.redos.addLast(redo);
    }

    void redoPair(Operation redo, Operation undo) {
        this.redos.remove(redo);
        this.operations.addLast(undo);
    }

    public void addChangeListener(UndoRedoSupport.ChangeListener cl) {
        this.operations.addChangeListener(cl);
    }

    public void removeChangeListener(UndoRedoSupport.ChangeListener cl) {
        this.operations.removeChangeListener(cl);
    }

    public void addExternalOperation(ExternalOperation op) {
        this.pendingExternals.add(op);
    }

    public List<ExternalOperation> getPendingExternals() {
        if (this.pendingExternals.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.pendingExternals.isEmpty()) {
            System.err.println("pending externals: " + this.pendingExternals);
        }
        return new ArrayList<ExternalOperation>(this.pendingExternals);
    }

    private static class Operations {
        private final Deque<Operation> operationsQue = new ArrayDeque<Operation>();
        private final TLongObjectMap<Operation> operationsMap = new TLongObjectHashMap();
        private final CopyOnWriteArrayList<UndoRedoSupport.ChangeListener> changeListeners = new CopyOnWriteArrayList();

        private Operations() {
        }

        void addLast(Operation op) {
            long id = op.getId();
            Operation old = (Operation)this.operationsMap.put(id, (Object)op);
            if (old != null) {
                this.operationsQue.remove(old);
                op.combine(old);
            }
            this.operationsQue.addLast(op);
            this.fireChangeEvent();
        }

        Operation getLast() {
            if (this.operationsQue.size() < 1) {
                return null;
            }
            Operation op = this.operationsQue.getLast();
            return op;
        }

        Collection<Operation> getAll() {
            return this.operationsQue;
        }

        Operation getCombined(long id) {
            return (Operation)this.operationsMap.get(id);
        }

        Operation removeLast() {
            Operation op = this.operationsQue.pollLast();
            if (op != null) {
                this.operationsMap.remove(op.getId());
            }
            this.fireChangeEvent();
            return op;
        }

        Operation remove(long id) {
            Operation op = (Operation)this.operationsMap.remove(id);
            if (op != null) {
                this.operationsQue.remove(op);
            }
            this.fireChangeEvent();
            return op;
        }

        void clear() {
            this.operationsQue.clear();
            this.operationsMap.clear();
            this.fireChangeEvent();
        }

        private void fireChangeEvent() {
            final Iterator<UndoRedoSupport.ChangeListener> it = this.changeListeners.iterator();
            ThreadUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    while (it.hasNext()) {
                        UndoRedoSupport.ChangeListener l = (UndoRedoSupport.ChangeListener)it.next();
                        try {
                            l.onChanged();
                        }
                        catch (Throwable t) {
                            Logger.defaultLogError(t);
                        }
                    }
                }
            });
        }

        void addChangeListener(UndoRedoSupport.ChangeListener cl) {
            this.changeListeners.add(cl);
        }

        void removeChangeListener(UndoRedoSupport.ChangeListener cl) {
            this.changeListeners.remove(cl);
        }
    }

    private static class Weak {
        private final WeakReference<UndoContext> reference;

        Weak(UndoContext context) {
            this.reference = new WeakReference<UndoContext>(context);
        }

        UndoContext get() {
            return (UndoContext)this.reference.get();
        }
    }
}

