package org.simantics.db.common.validation;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.types.Type;

public class L0Validations {

	public static String checkValueType(ReadGraph graph, Resource subject, Resource predicate) throws DatabaseException {

		if (subject == null)
			return null;
		if (predicate == null)
			return null;

		Layer0 L0 = Layer0.getInstance(graph);
		if(graph.isSubrelationOf(predicate, L0.HasProperty)) {
			Resource object = graph.getPossibleObject(subject, predicate);
			if(object == null) return null;
			String valueTypeText = graph.getPossibleRelatedValue(predicate, L0.RequiresValueType, Bindings.STRING);
			if(valueTypeText != null) {
				Type valueType = CommonDBUtils.getSCLType(graph, subject, valueTypeText);
				if(valueType == null) {
					Resource range = graph.getPossibleObject(predicate, L0.HasRange);
					if(range != null) {
						return null;
					} else {
						StringBuilder sb = new StringBuilder()
								.append("The value type ")
								.append(valueType)
								.append(" of predicate ")
								.append(NameUtils.getSafeName(graph, predicate, true))
								.append(" cannot be resolved.")
								.append(NameUtils.getSafeName(graph, object, true))
								.append(".");
						return sb.toString();
					}
				}
				String valueTypeText2 = graph.getPossibleRelatedValue(object, L0.HasValueType, Bindings.STRING);
				if(valueTypeText2 != null) {
					Type valueType2 = CommonDBUtils.getSCLType(graph, subject, valueTypeText2);
					if(valueType2 == null) {
						StringBuilder sb = new StringBuilder()
								.append("The value type ")
								.append(valueType2)
								.append(" of object ")
								.append(NameUtils.getSafeName(graph, object, true))
								.append(" cannot be resolved.");
						return sb.toString();
					}
					if(!valueType.equals(valueType2)) {
						StringBuilder sb = new StringBuilder()
								.append("The value type ")
								.append(valueType)
								.append(" of predicate ")
								.append(NameUtils.getSafeName(graph, predicate, true))
								.append(" does not match the value type ")
								.append(valueType2)
								.append(" of object ")
								.append(NameUtils.getSafeName(graph, object, true))
								.append(".");
						return sb.toString();
					}
				}
			}
		}

		return null;

	}

}
