/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.Collection;
import java.util.HashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class PossibleIndexRoot extends ResourceRead<Resource> {

    public PossibleIndexRoot(Resource resource) {
        super(resource);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {

    	Layer0 L0 = Layer0.getInstance(graph);
    	
        if (graph.isInstanceOf(resource, L0.IndexRoot))
            return resource;
        
        Collection<Resource> parents = new HashSet<Resource>(graph.getObjects(resource, L0.IsOwnedBy));
        Resource parent = parents.size() == 1 ? parents.iterator().next() : null;

        // What is this?
        if(resource.equals(parent))
        	parent = null;

        if (parent == null) {
        	
        	if(parents.size() > 1) {
        		// Maybe we have a case where there is ConsistsOf and HasProperty that is incorrectly classified as IsComposedOf
        		parent = graph.getPossibleObject(resource, L0.PartOf);
        	} 

        	// Assertion object?
        	if(parent == null)
        		parent = graph.getPossibleObject(resource, L0.HasObjectInverse);
        	
        	if(parent == null) return null;
        	
        }
        
        return graph.syncRequest(new PossibleIndexRoot(parent));

    }

}
