/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.wrapper;

import org.simantics.db.ReadGraph;
import org.simantics.db.procedure.MultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;

public class NoneToSyncMultiProcedure<T> implements SyncMultiProcedure<T> {

    private final MultiProcedure<T> procedure;

    public NoneToSyncMultiProcedure(MultiProcedure<T> procedure) {
        this.procedure = procedure;
    }

    @Override
    public void execute(ReadGraph graph, final T result) {
        procedure.execute(result);
    }

    @Override
    public void finished(ReadGraph graph) {
        procedure.finished();
    }

    @Override
    public void exception(ReadGraph graph, Throwable t) {
         procedure.exception(t);
    }

    @Override
    public String toString() {
        return "NoneToAsyncMultiProcedure -> " + procedure;
    }

}
