/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.adaption.AdaptionService;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;

final public class Adapter<T> extends BinaryRead<Resource,Class<T>,T> {
    
    public Adapter(Resource resource, Class<T> clazz) {
    	super(resource, clazz);
    }

	@Override
	public T perform(ReadGraph graph) throws DatabaseException {
		
		final AdaptionService service = graph.peekService(AdaptionService.class);
		if (service == null) throw new ServiceException("No AdaptionService available");
		
		return service.adapt(graph, parameter, parameter, Resource.class, parameter2, false);
		
	}
    
    @Override
    public String toString() {
        return "Adapter for resource " + parameter.getResourceId() + " as " + parameter2.getName();
    }

    
}
