package org.simantics.db.common.internal.config;

import java.io.File;

import org.simantics.db.common.internal.Activator;
import org.simantics.db.common.utils.Logger;

/**
 * @author Tuukka Lehtonen
 * @see Logger
 */
public class InternalClientConfig {

	/**
	 * Name of the DB client temporary data directory. 
	 */
	public final static String DB_CLIENT_TEMP_DIR_NAME = "temp";

	/**
	 * Name of the DB client log file. 
	 */
	public final static String DB_CLIENT_LOG_FILE_NAME = "db-client.log";

	/**
	 * The directory used for temporary data by the database client. If the
	 * program if being ran in an OSGi container, {@link Activator} will attempt
	 * to configure this path based on the current OSGi instance area location.
	 * 
	 * @see Activator
	 */
	public static File DB_CLIENT_TEMP_DIR = new File(DB_CLIENT_TEMP_DIR_NAME);

	/**
	 * A relative or full absolute path to the log file created by
	 * {@link Logger}. Used statically for initialization in {@link Logger} and
	 * therefore must be configured prior to referencing {@link Logger}. If the
	 * program if being ran in an OSGi container, {@link Activator} will attempt
	 * to configure this path based on the current OSGi instance area location.
	 * 
	 * @see Activator
	 * @see Logger
	 */
	public static String DB_CLIENT_LOG_FILE = DB_CLIENT_LOG_FILE_NAME;

}
