/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.utils;

import gnu.trove.list.array.TByteArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.datatypes.utils.BTreeContentBean;
import org.simantics.datatypes.utils.PossibleResource;
import org.simantics.datatypes.utils.PossibleVariant;
import org.simantics.datatypes.utils.PossibleVariantInputStream;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.Bytes;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.XSupport;

class BTreeContentBinding
extends Binding {
    private final SerialisationSupport ss;
    private final XSupport xs;
    private final Serializer serializer = new Serializer(){

        public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object obj) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void serialize(DataOutput out, Object obj) throws IOException {
            byte[] data = this.serialize(obj);
            out.write(data);
        }

        public Object deserialize(DataInput in, List<Object> identities) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object deserialize(DataInput in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void deserializeTo(DataInput in, List<Object> identities, Object dst) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void deserializeTo(DataInput in, Object dst) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void skip(DataInput in, List<Object> identities) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void skip(DataInput in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Integer getConstantSize() {
            throw new UnsupportedOperationException();
        }

        public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int getSize(Object obj) throws IOException {
            return this.serialize(obj).length;
        }

        public int getMinSize() {
            throw new UnsupportedOperationException();
        }

        private void addBE(TByteArrayList bytes, int value) {
            bytes.add((byte)(value >>> 24 & 0xFF));
            bytes.add((byte)(value >>> 16 & 0xFF));
            bytes.add((byte)(value >>> 8 & 0xFF));
            bytes.add((byte)(value & 0xFF));
        }

        private void addBE(TByteArrayList bytes, long value) {
            bytes.add((byte)(value >>> 56 & 0xFFL));
            bytes.add((byte)(value >>> 48 & 0xFFL));
            bytes.add((byte)(value >>> 40 & 0xFFL));
            bytes.add((byte)(value >>> 32 & 0xFFL));
            bytes.add((byte)(value >>> 24 & 0xFFL));
            bytes.add((byte)(value >>> 16 & 0xFFL));
            bytes.add((byte)(value >>> 8 & 0xFFL));
            bytes.add((byte)(value & 0xFFL));
        }

        public byte[] serialize(Object obj) throws IOException {
            Object pr;
            BTreeContentBean bean = (BTreeContentBean)((Object)obj);
            TByteArrayList bytes = new TByteArrayList();
            bytes.add(bean.leaf ? (byte)1 : 0);
            this.addBE(bytes, bean.n);
            Binding pbv = PossibleVariant.BINDING;
            Serializer pbs = pbv.serializer();
            this.addBE(bytes, bean.key.length);
            Object[] objectArray = bean.key;
            int n = bean.key.length;
            int n2 = 0;
            while (n2 < n) {
                PossibleVariant l = objectArray[n2];
                byte[] ser = pbs.serialize((Object)l);
                bytes.add(ser);
                ++n2;
            }
            this.addBE(bytes, bean.value.length);
            objectArray = bean.value;
            n = bean.value.length;
            n2 = 0;
            while (n2 < n) {
                pr = objectArray[n2];
                if (((PossibleResource)pr).r != null) {
                    bytes.add((byte)1);
                    this.addBE(bytes, BTreeContentBinding.this.xs.convertDelayedResourceToResource(((PossibleResource)pr).r).getResourceId());
                } else {
                    bytes.add((byte)0);
                }
                ++n2;
            }
            this.addBE(bytes, bean.c.length);
            objectArray = bean.c;
            n = bean.c.length;
            n2 = 0;
            while (n2 < n) {
                pr = objectArray[n2];
                if (((PossibleResource)pr).r != null) {
                    bytes.add((byte)1);
                    this.addBE(bytes, BTreeContentBinding.this.xs.convertDelayedResourceToResource(((PossibleResource)pr).r).getResourceId());
                } else {
                    bytes.add((byte)0);
                }
                ++n2;
            }
            return bytes.toArray();
        }

        int readBE4(byte[] bytes, int byteIndex) {
            int result = (bytes[byteIndex++] & 0xFF) << 24 | (bytes[byteIndex++] & 0xFF) << 16 | (bytes[byteIndex++] & 0xFF) << 8 | bytes[byteIndex++] & 0xFF;
            return result;
        }

        long readBE8(byte[] bytes, int byteIndex) {
            long result = (long)(bytes[byteIndex++] & 0xFF) << 56 | (long)(bytes[byteIndex++] & 0xFF) << 48 | (long)(bytes[byteIndex++] & 0xFF) << 40 | (long)(bytes[byteIndex++] & 0xFF) << 32 | (long)(bytes[byteIndex++] & 0xFF) << 24 | (long)(bytes[byteIndex++] & 0xFF) << 16 | (long)(bytes[byteIndex++] & 0xFF) << 8 | (long)(bytes[byteIndex++] & 0xFF);
            return result;
        }

        public Object deserialize(byte[] data) throws IOException {
            BTreeContentBean result = new BTreeContentBean();
            try {
                result.leaf = data[0] == 1;
                int byteIndex = 1;
                result.n = this.readBE4(data, byteIndex);
                Binding pbv = PossibleVariant.BINDING;
                Serializer pbs = pbv.serializer();
                int keySize = this.readBE4(data, byteIndex += 4);
                result.key = new PossibleVariant[keySize];
                byteIndex += 4;
                int i = 0;
                while (i < keySize) {
                    PossibleVariant v;
                    PossibleVariantInputStream is = new PossibleVariantInputStream(data, byteIndex);
                    result.key[i] = v = (PossibleVariant)pbs.deserialize((InputStream)is);
                    byteIndex = is.getOffset();
                    ++i;
                }
                int valueSize = this.readBE4(data, byteIndex);
                result.value = new PossibleResource[valueSize];
                byteIndex += 4;
                int i2 = 0;
                while (i2 < valueSize) {
                    boolean has;
                    boolean bl = has = Bytes.read((byte[])data, (int)byteIndex++) > 0;
                    if (has) {
                        result.value[i2] = PossibleResource.read(BTreeContentBinding.this.ss, this.readBE8(data, byteIndex));
                        byteIndex += 8;
                    } else {
                        result.value[i2] = new PossibleResource();
                    }
                    ++i2;
                }
                int childSize = this.readBE4(data, byteIndex);
                result.c = new PossibleResource[childSize];
                byteIndex += 4;
                int i3 = 0;
                while (i3 < childSize) {
                    boolean has;
                    boolean bl = has = Bytes.read((byte[])data, (int)byteIndex++) > 0;
                    if (has) {
                        result.c[i3] = PossibleResource.read(BTreeContentBinding.this.ss, this.readBE8(data, byteIndex));
                        byteIndex += 8;
                    } else {
                        result.c[i3] = new PossibleResource();
                    }
                    ++i3;
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            return result;
        }
    };

    public BTreeContentBinding(SerialisationSupport ss, XSupport xs) {
        this.ss = ss;
        this.xs = xs;
    }

    public void accept(Binding.Visitor1 v, Object obj) {
        throw new UnsupportedOperationException();
    }

    public <T> T accept(Binding.Visitor<T> v) {
        throw new UnsupportedOperationException();
    }

    public boolean isInstance(Object obj) {
        throw new UnsupportedOperationException();
    }

    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        throw new UnsupportedOperationException();
    }

    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        throw new UnsupportedOperationException();
    }

    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        throw new UnsupportedOperationException();
    }

    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        throw new UnsupportedOperationException();
    }

    protected void toString(Object value, BindingPrintContext ctx) throws BindingException {
        throw new UnsupportedOperationException();
    }

    public int getComponentCount() {
        throw new UnsupportedOperationException();
    }

    public Binding getComponentBinding(int index) {
        throw new UnsupportedOperationException();
    }

    public Binding getComponentBinding(ChildReference path) {
        throw new UnsupportedOperationException();
    }

    public Serializer serializer() throws RuntimeSerializerConstructionException {
        return this.serializer;
    }
}

