package org.simantics.datatypes.utils;

import org.simantics.databoard.util.Bean;

final class LogContentBean extends Bean {
	public boolean leaf;
	public int h;
	public int n;
	public long[] stamps;
	public PossibleResource[] resources;
	public LogContentBean() {
//		System.err.println("counter=" + counter++);
	}
	public static LogContentBean create(int t, int h, boolean leaf) {
		LogContentBean result = new LogContentBean();
		result.leaf = leaf;
		result.n = 0;
		result.stamps = new long[t];
		result.resources = new PossibleResource[t];
		for(int i=0;i<t;i++) result.resources[i] = new PossibleResource();
		return result;
	}
}