/*******************************************************************************
 * Copyright (c) 2010- Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import junit.framework.TestCase;

import org.simantics.databoard.accessor.impl.DirectoryWatch;
import org.simantics.databoard.accessor.impl.DirectoryWatch.DirectoryEvent;
import org.simantics.databoard.accessor.impl.DirectoryWatch.DirectoryListener;

/**
 * This test case tests Wathc Servlet.
 * 
 * It creates a random named directory under $TMP$
 * There it 
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class TestDirectoryWatch extends TestCase {

	File tmpDir;
	
	public static File createTmpDir()
	{
		String tmp = System.getenv("tmp");
		if (tmp==null) tmp = "c:/temp";
		Random r = new Random();
		String randomName = "tmp-"+(r.nextInt(10000)+10000);
		File tmpDir = new File(tmp+"/"+randomName);
		Boolean ok = tmpDir.mkdirs();
		assertTrue( ok );
		return tmpDir;
	}
	
	public void setUp() throws Exception {
		tmpDir = createTmpDir();
	}
	
	@Override
	protected void tearDown() throws Exception {
		boolean ok = tmpDir.delete();
		if (!ok) System.err.println(tmpDir+" was not removed.");
	}	
	
	public void testAll() 
	throws Exception {
		
		FileFilter filter = new FileFilter() {
			public boolean accept(File pathname) {				
				return pathname.getAbsolutePath().toLowerCase().endsWith(".dbb");
			}};
			
		DirectoryWatch monitor = new DirectoryWatch(tmpDir, filter);
		
		final DirectoryEvent result = new DirectoryEvent();
		
		// Set listener that collects changes
		monitor.addListener(new DirectoryListener() {
			@Override
			public void onWatchEvent(DirectoryEvent e) {
				result.filesAdded.addAll(e.filesAdded);
				result.filesRemoved.addAll(e.filesRemoved);
			}});

		// Create file names
		List<File> files = new ArrayList<File>();
		for (int i=1; i<10; i++) {
			files.add( new File(tmpDir, "file-"+i+".dbb") );
		}
		
		// Create files
		for (File f : files)
		{
			f.createNewFile();
		}		
		Thread.sleep( DirectoryWatch.POLL_INTERVAL*2 );		
		assertTrue( files.containsAll( result.filesAdded ) );
		assertTrue( result.filesAdded.containsAll( files ) );
		assertTrue( result.filesRemoved.isEmpty() );		
		result.filesAdded.clear();
		
		// Delete files
		for (File f : files)
			f.delete();
		Thread.sleep( DirectoryWatch.POLL_INTERVAL*2 );		
		assertTrue( files.containsAll( result.filesRemoved ) );
		assertTrue( result.filesRemoved.containsAll( files ) );
		assertTrue( result.filesAdded.isEmpty() );		
		result.filesRemoved.clear();
		
		monitor.close();		
	}
	
}

