/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import org.junit.Before;
import org.junit.Test;
import org.simantics.databoard.parser.repository.DataTypeRepository;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;

public class ParserFailureTests {

	DataTypeRepository repository;
	
	@Before
	public void setUp() {
		repository = new DataTypeRepository();
	}	
	
	@Test(expected = DataTypeSyntaxError.class) 
	public void testIncorrectUnion1() throws DataTypeSyntaxError {
		repository.addDefinitions("type A = A | B");
	}
	
	@Test(expected = DataTypeSyntaxError.class) 
	public void testIncorrectUnion2() throws DataTypeSyntaxError {
		repository.addDefinitions("type X = |Integer(range=0)");
	}
	
	@Test(expected = DataTypeSyntaxError.class) 
	public void testUndefinedReference() throws DataTypeSyntaxError {
		repository.addDefinitions("type Foo = Bar");
	}
	
	@Test(expected = DataTypeSyntaxError.class) 
	public void testCircularDefinition() throws DataTypeSyntaxError {
		repository.addDefinitions("type Foo = Bar " +
				       "type Bar = Foo " 
				      );
	}
	
	@Test(expected = DataTypeSyntaxError.class) 
	public void testInvalidAttribute() throws DataTypeSyntaxError {
		repository.addDefinitions("type Foo = String(range=3)");
	}
}
