/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example.old;

import java.util.Arrays;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Length;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;

/**
 * In this duck-typing example, there are two classes with compatible contents.
 * Contents of one class is moved to another using binary serialization.  
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class AdaptionExample3 {
	
	static class DoubleVector {
		public DoubleVector() {}
		public double x, y, z;
	}
	static final Binding DoubleVectorBinding = Bindings.getBindingUnchecked( DoubleVector.class );
	static final Serializer DoubleVectorSerializer = Bindings.getSerializerUnchecked( DoubleVectorBinding );
	
	static class DoubleArray {
		public DoubleArray() {}
		
		public @Length("3") double[] array;
	}
	static final Binding DoubleArrayBinding = Bindings.getBindingUnchecked( DoubleArray.class );
	static final Serializer DoubleArraySerializer = Bindings.getSerializerUnchecked( DoubleArrayBinding );
	
	public static void main(String[] args) throws Exception {
		
		// Create double array
		DoubleArray doubleArray = new DoubleArray();
		doubleArray.array = new double[] {3, 6, 9};
		
		// Serialize doubleArray to binary data format
		byte[] data = DoubleArraySerializer.serialize( doubleArray );
		System.out.println("DoubleArray: " + Arrays.toString(doubleArray.array) );
		
		// Unserialize binary data to DoubleVector			
		DoubleVector doubleVector = (DoubleVector) DoubleVectorSerializer.deserialize( data );
		System.out.printf("DoubleVector: %f, %f, %f\n", doubleVector.x, doubleVector.y, doubleVector.z);
		
				
	
				
	}
	

}

