/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.awt.Color;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.query.ChartItemIndexQuery;
import org.simantics.charts.query.SetChartItemIndexRequest;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;

public class SetIndexItem
extends ContributionItem
implements SelectionListener {
    int index;
    Color color;
    String label;
    Image image;
    LocalResourceManager rm;
    List<Resource> chartItems;
    boolean analogIcon;

    public SetIndexItem(Color color, int index, String label, boolean analogIcon, List<Resource> chartItems) {
        super("org.simantics.charts.ui.ColorItem." + index);
        this.index = index;
        this.label = label;
        this.color = color;
        this.chartItems = chartItems;
        this.analogIcon = analogIcon;
    }

    public void fill(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 32);
        item.setText(String.valueOf(this.index));
        item.addSelectionListener((SelectionListener)this);
        boolean selected = false;
        if (this.chartItems.size() == 1) {
            try {
                Integer selIndex = (Integer)Simantics.getSession().sync((ReadInterface)new ChartItemIndexQuery(this.chartItems.get(0)));
                selected = selIndex != null && this.index == selIndex;
            }
            catch (DatabaseException databaseException) {}
        }
        item.setSelection(selected);
        if (this.rm == null) {
            this.rm = new LocalResourceManager(JFaceResources.getResources());
        }
        ImageDescriptor icon = Activator.getDefault().chartIcons.createIcon(this.analogIcon, this.color, selected);
        this.image = (Image)this.rm.get((DeviceResourceDescriptor)icon);
        item.setImage(this.image);
    }

    public void dispose() {
        if (this.rm != null) {
            this.rm.dispose();
        }
        super.dispose();
    }

    public void widgetSelected(SelectionEvent e) {
        for (Resource chartItem : this.chartItems) {
            Session s = Simantics.getSession();
            s.markUndoPoint();
            s.async((WriteInterface)new SetChartItemIndexRequest(chartItem, this.index));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

