/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ReadInterface;

public class WidgetSupportImpl
implements WidgetSupport {
    protected final CopyOnWriteArrayList<Widget> widgets = new CopyOnWriteArrayList();
    protected final Map<String, Object> parameters = new HashMap<String, Object>();
    protected Object lastInput = NO_INPUT;
    protected ISessionContext lastContext = null;
    private boolean finished = false;
    protected final List<Listener<?>> listeners = new CopyOnWriteArrayList();

    @Override
    public synchronized void register(Widget widget) {
        this.widgets.add(widget);
    }

    @Override
    public void update(Widget widget) {
        if (this.lastContext != null && this.lastInput != NO_INPUT) {
            widget.setInput(this.lastContext, this.lastInput);
        }
    }

    @Override
    public void update() {
        for (Widget widget : this.widgets) {
            this.update(widget);
        }
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public <T> T getInput() {
        return (T)this.lastInput;
    }

    public void fireInput(ISessionContext context, Object input) {
        this.lastInput = input;
        this.lastContext = context;
        for (Widget widget : this.widgets) {
            widget.setInput(context, input);
            for (Listener<?> listener : this.listeners) {
                listener.execute(input);
            }
        }
    }

    @Override
    public <T> T getParameter(String key) {
        return (T)this.parameters.get(key);
    }

    @Override
    public void setParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    @Override
    public <T> T getInput(ReadGraph graph) throws DatabaseException {
        return (T)graph.sync((ReadInterface)new ParametrizedPrimitiveRead<WidgetSupport, T>(this){
            Listener<T> procedure;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void register(ReadGraph graph, Listener<T> procedure) {
                List<Listener<?>> list = WidgetSupportImpl.this.listeners;
                synchronized (list) {
                    if (WidgetSupportImpl.this.listeners.contains(procedure)) {
                        return;
                    }
                    this.procedure = procedure;
                    WidgetSupportImpl.this.listeners.add(procedure);
                    procedure.execute(WidgetSupportImpl.this.lastInput);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unregistered() {
                List<Listener<?>> list = WidgetSupportImpl.this.listeners;
                synchronized (list) {
                    WidgetSupportImpl.this.listeners.remove(this.procedure);
                    this.procedure = null;
                }
            }
        });
    }
}

